// DEPRECATED !!!   .  !

unit VisStatusShape;

interface

uses
{$ifdef VER150}
  DesignIntf, DesignEditors, DesignWindows, DsnConst,
{$else}
  DsgnIntf,
{$endif}
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, stdctrls, ScadaBase;


type

  TVisStatusShape = class(TCustomScadaObject)
  private
    { Private declarations }
    FTagName: TTagName;
//    FTagPath: TTagPath;
    FTagInfo: TTagName;
    FChannelName: TChannelName;
    FFlashing: boolean;
    FLineColor: TColor;
    FColorOn: TColor;
    FColorOff: TColor;

    //  
    FShape: TShape;
    FShapeType: TShapeType;

    procedure SetShapeType(Value: TShapeType);
    procedure SetColorOff(Value: TColor);
    procedure SetLineColor(Value: TColor);


  protected
    FTagStatus: integer;

    procedure SetShapeStatus(Value: integer);
  public
    { Public declarations }
    ShapeStatus: integer;

    constructor Create(AOwner: TComponent); override;
    procedure Init; override;
    procedure Process; override;
  published
    { Published declarations }
    property TagName: TTagName read FTagName write FTagName;
//    property TagPath: TTagPath read FTagPath write FTagPath;
    property TagInfo: TTagName read FTagInfo write FTagInfo;
    property Flashing: boolean read FFlashing write FFlashing;
    property LineColor: TColor read FLineColor write SetLineColor;
    property ColorOn: TColor read FColorOn write FColorOn;
    property ColorOff: TColor read FColorOff write SetColorOff;
    property Channel: TChannelName read FChannelName write FChannelName;
    property Shape: TShapeType read FShapeType write SetShapeType;

  end;

{
  TImageFilenameProperty = class(TPropertyEditor)
    function GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;
    function GetValue: string; override;
    procedure SetValue(const Value: string); override;
  end;
}

procedure Register;

implementation
uses
  TagStorage,
  ExtDlgs,
  numbers,
  RpVisualUtils,
  RpVisualGlobal;

procedure Register;
begin
  RegisterComponents('Scada', [TVisStatusShape]);
end;

{ TVisualDevice }

constructor TVisStatusShape.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Width := 100;
  Height := 100;
  ShowHint := true;

  FTagStatus := -1;

  //  
  FShape := TShape.Create(Self);
  FShape.Parent := self;
  FShape.Visible := true;
  FShape.Align := alClient;
  FShape.OnMouseUp := OnDeviceMouseUp;

//FShape.Pen.Color := clWhite;

  ShapeStatus := -1;
end;


procedure TVisStatusShape.SetShapeType(Value: TShapeType);
begin
  FShapeType := Value;
  FShape.Shape := Value;
end;


procedure TVisStatusShape.SetColorOff(Value: TColor);
begin
  FColorOff := Value;
  FShape.Brush.Color := Value;
end;

procedure TVisStatusShape.SetLineColor(Value: TColor);
begin
  FLineColor := Value;
  FShape.Pen.Color := Value;
end;



procedure TVisStatusShape.SetShapeStatus(Value: integer);
begin
  if (value <> ShapeStatus) or ((value <> ShapeStatus) and (FFlashing)) then begin
    if value > 0 then begin
      if (FFlashing) and (FShape.Brush.Color = FColorOn) then begin
        FShape.Brush.Color := FColorOff;
      end else
        FShape.Brush.Color := FColorOn;
    end else
      FShape.Brush.Color := FColorOff;
  end;
end;




// INIT
procedure TVisStatusShape.Init;
var
  _tagname: string;
begin
  inherited;
  _tagname := repl(TagName, TagIdRoot, TagRoot);

  FTagStatus := GetTagIndex( iif(TagPath='', '', TagPath + '.') + _TagName);
  IsConnectionBad := (FTagStatus<0);
end;

// PROCESS HANDLER
procedure TVisStatusShape.Process;
var
  value: integer;
begin
  inherited;

  value := GetTagValue(FTagStatus);
  SetShapeStatus(value);
  IsValueBad := (value < 0);
end;



end.
