unit VisVespASetup;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, VisVespA, Mask, ExtCtrls, Buttons, ComCtrls, RpVisualGlobal;

type
  TVisVespASetupForm = class(TForm)
    Panel1: TPanel;
    DeviceNameEdit: TMaskEdit;
    Label1: TLabel;
    Label2: TLabel;
    LabelEdit: TMaskEdit;
    Label3: TLabel;
    TagNameEdit: TMaskEdit;
    TagPathEdit: TMaskEdit;
    Label4: TLabel;
    Panel2: TPanel;
    PicNameEdit: TMaskEdit;
    Label6: TLabel;
    ImageXEdit: TEdit;
    ImageYEdit: TEdit;
    Label7: TLabel;
    Label8: TLabel;
    udImageY: TUpDown;
    udImageX: TUpDown;
    Label9: TLabel;
    ImageSXEdit: TEdit;
    ImageSYEdit: TEdit;
    Label10: TLabel;
    Label11: TLabel;
    udImageSY: TUpDown;
    udImageSX: TUpDown;
    Panel3: TPanel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    MachXEdit: TEdit;
    MachYEdit: TEdit;
    udMachY: TUpDown;
    udMachX: TUpDown;
    MachSXEdit: TEdit;
    MachSYEdit: TEdit;
    udMachSY: TUpDown;
    udMachSX: TUpDown;
    Label12: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    Panel4: TPanel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    Label27: TLabel;
    LabelXEdit: TEdit;
    LabelYEdit: TEdit;
    udLabelY: TUpDown;
    udLabelX: TUpDown;
    OkButton: TBitBtn;
    CancelButton: TBitBtn;
    ImagePanel: TPanel;
    ImageView: TImage;
    Timer: TTimer;
    cbImageAnim: TCheckBox;
    btImageReset: TSpeedButton;
    Panel5: TPanel;
    Label5: TLabel;
    DatTagPostfixEdit: TMaskEdit;
    DatNameEdit: TMaskEdit;
    Label24: TLabel;
    Label25: TLabel;
    Label26: TLabel;
    Label28: TLabel;
    Label29: TLabel;
    Label30: TLabel;
    Label31: TLabel;
    Label32: TLabel;
    DatXEdit: TEdit;
    DatYEdit: TEdit;
    udDatY: TUpDown;
    udDatX: TUpDown;
    DatSXEdit: TEdit;
    DatSYEdit: TEdit;
    udDatSY: TUpDown;
    udDatSX: TUpDown;
    DatList: TListBox;
    btDatAdd: TSpeedButton;
    btDatDel: TSpeedButton;
    cmbDatForm: TComboBox;
    Label33: TLabel;
    Label34: TLabel;
    cmbDatColor: TComboBox;
    Label35: TLabel;
    OpFreqMaxEdit: TMaskEdit;
    udOpFreqMax: TUpDown;
    procedure DeviceNameEditChange(Sender: TObject);
    procedure LabelEditChange(Sender: TObject);
    procedure TagPathEditChange(Sender: TObject);
    procedure TagNameEditChange(Sender: TObject);
    procedure MachYEditChange(Sender: TObject);
    procedure MachSXEditChange(Sender: TObject);
    procedure MachSYEditChange(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure LabelXEditChange(Sender: TObject);
    procedure LabelYEditChange(Sender: TObject);
    procedure ImageXEditChange(Sender: TObject);
    procedure ImageYEditChange(Sender: TObject);
    procedure ImageSXEditChange(Sender: TObject);
    procedure ImageSYEditChange(Sender: TObject);
    procedure btOpenPicClick(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure btImageResetClick(Sender: TObject);
    procedure MachXEditChange(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure DatListClick(Sender: TObject);
    procedure DatNameEditChange(Sender: TObject);
    procedure DatTagPostfixEditChange(Sender: TObject);
    procedure cmbDatColorChange(Sender: TObject);
    procedure cmbDatFormChange(Sender: TObject);
    procedure DatXEditChange(Sender: TObject);
    procedure DatYEditChange(Sender: TObject);
    procedure DatSXEditChange(Sender: TObject);
    procedure DatSYEditChange(Sender: TObject);
    procedure btDatAddClick(Sender: TObject);
    procedure btDatDelClick(Sender: TObject);
    procedure OpFreqMaxEditChange(Sender: TObject);
  private
    NotLoaded: boolean;
    ImageAnimNum: integer;
    procedure Modify;
    procedure SetImageSize;
  public
    M: TVisVespA;
    D: TVisVespAEditor;
  end;

var
  VisVespASetupForm: TVisVespASetupForm;

implementation
uses ExtDlgs, inifiles;

{$R *.DFM}

procedure TVisVespASetupForm.FormActivate(Sender: TObject);
var
  s: string;
  i: integer;
begin
  DeviceNameEdit.Text := M.DeviceName;
  TagPathEdit.Text := M.TagPath;
  TagNameEdit.Text := M.TagName;
  LabelEdit.Text := M.LabelObj.Caption;
  OpFreqMaxEdit.Text := IntToStr(M.OpFreqMax);

  udMachX.Position := M.Left;
  udMachY.Position := M.Top;
  udMachSX.Position := M.Width;
  udMachSY.Position := M.Height;

  udLabelX.Position := M.LabelObj.Left;
  udLabelY.Position := M.LabelObj.Top;

  PicNameEdit.Text := M.ImagePic;
  udImageX.Position := M.ImageObj.Left;
  udImageY.Position := M.ImageObj.Top;
  udImageSX.Position := M.ImageObj.Width;
  udImageSY.Position := M.ImageObj.Height;

  s := VisImagesPath + M.ImagePic;
  try
    if FileExists(s) then ImageView.Picture.LoadFromFile(s);
    SetImageSize;
    ImagePanel.Color := clBtnFace;
  except
    ImagePanel.Color := clRed;
  end;

  //  
  for i:=0 to M.DatCount-1 do begin
    DatList.Items.Add(M.Datchik[i].Name);
  end;
  if M.DatCount>0 then DatList.ItemIndex := 0;
  DatListClick(nil);

  NotLoaded := false;
end;


procedure TVisVespASetupForm.DatListClick(Sender: TObject);
begin
  if DatList.ItemIndex < 0 then begin
    DatList.Clear;
    DatNameEdit.Text := '';
    DatTagPostfixEdit.Text := '';
    cmbDatForm.ItemIndex := 0;
    cmbDatColor.ItemIndex := 0;
    udDatX.Position := 0;
    udDatY.Position := 0;
    udDatSX.Position := 5;
    udDatSY.Position := 5;
  end else if DatList.ItemIndex < M.DatCount then begin
    DatNameEdit.Text := M.Datchik[DatList.ItemIndex].Name;
    DatTagPostfixEdit.Text := M.Datchik[DatList.ItemIndex].TagPostfix;
    cmbDatForm.ItemIndex := ord(M.Datchik[DatList.ItemIndex].Shape.Shape);
    cmbDatColor.ItemIndex := M.Datchik[DatList.ItemIndex].ColorScheme;
    udDatX.Position := M.Datchik[DatList.ItemIndex].Shape.Left;
    udDatY.Position := M.Datchik[DatList.ItemIndex].Shape.Top;
    udDatSX.Position := M.Datchik[DatList.ItemIndex].Shape.Width;
    udDatSY.Position := M.Datchik[DatList.ItemIndex].Shape.Height;
  end;
end;


procedure TVisVespASetupForm.FormCreate(Sender: TObject);
begin
  NotLoaded := true;
  with TIniFile.Create(GetCurrentDir + '\VisScada.ini') do begin
    Left := ReadInteger('VisVespA', 'Left', 6);
    Top := ReadInteger('VisVespA', 'Top', 4);
    cbImageAnim.Checked := ReadBool('VisVespA', 'ImageAnim', false);
    Free;
  end;
end;

procedure TVisVespASetupForm.FormDestroy(Sender: TObject);
begin
  with TIniFile.Create(GetCurrentDir + '\VisScada.ini') do begin
    WriteInteger('VisVespA', 'Left', Left);
    WriteInteger('VisVespA', 'Top', Top);
    WriteBool('VisVespA', 'ImageAnim', cbImageAnim.Checked);
    Free;
  end;
end;


procedure TVisVespASetupForm.Modify;
begin
  M.Left := M.Left + 1;
  M.Left := M.Left - 1;
  D.Designer.Modified;
end;

procedure TVisVespASetupForm.DeviceNameEditChange(Sender: TObject);
begin
  if NotLoaded then exit;
  M.DeviceName := DeviceNameEdit.Text;
  D.Designer.Modified;
end;

procedure TVisVespASetupForm.LabelEditChange(Sender: TObject);
begin
  if NotLoaded then exit;
  M.LabelObj.Caption := LabelEdit.Text;
  M.FrameUpdate;
  Modify;
end;

procedure TVisVespASetupForm.TagPathEditChange(Sender: TObject);
begin
  if NotLoaded then exit;
  M.TagPath := TagPathEdit.Text;
  D.Designer.Modified;
end;

procedure TVisVespASetupForm.TagNameEditChange(Sender: TObject);
begin
  if NotLoaded then exit;
  M.TagName := TagNameEdit.Text;
  D.Designer.Modified;
end;

procedure TVisVespASetupForm.OpFreqMaxEditChange(Sender: TObject);
begin
  if (NotLoaded) or (OpFreqMaxEdit.Text='') then exit;
  M.OpFreqMax := StrToInt(OpFreqMaxEdit.Text);
  D.Designer.Modified;
end;

procedure TVisVespASetupForm.MachXEditChange(Sender: TObject);
begin
  if (NotLoaded) or (MachXEdit.Text='') then exit;
  M.Left := StrToInt(MachXEdit.Text);
  D.Designer.Modified;
end;

procedure TVisVespASetupForm.MachYEditChange(Sender: TObject);
begin
  if (NotLoaded) or (MachYEdit.Text='') then exit;
  M.Top := StrToInt(MachYEdit.Text);
  D.Designer.Modified;
end;

procedure TVisVespASetupForm.MachSXEditChange(Sender: TObject);
begin
  if (NotLoaded) or (MachSXEdit.Text='') then exit;
  M.Width := StrToInt(MachSXEdit.Text);
  D.Designer.Modified;
end;

procedure TVisVespASetupForm.MachSYEditChange(Sender: TObject);
begin
  if (NotLoaded) or (MachSYEdit.Text='') then exit;
  M.Height := StrToInt(MachSYEdit.Text);
  D.Designer.Modified;
end;


procedure TVisVespASetupForm.LabelXEditChange(Sender: TObject);
begin
  if (NotLoaded) or (LabelXEdit.Text='') then exit;
  M.LabelObj.Left := StrToInt(LabelXEdit.Text);
  M.FrameUpdate;
  Modify;
end;

procedure TVisVespASetupForm.LabelYEditChange(Sender: TObject);
begin
  if (NotLoaded) or (LabelXEdit.Text='') then exit;
  M.LabelObj.Top := StrToInt(LabelYEdit.Text);
  M.FrameUpdate;
  Modify;
end;

procedure TVisVespASetupForm.ImageXEditChange(Sender: TObject);
begin
  if (NotLoaded) or (ImageXEdit.Text='') then exit;
  M.ImageObj.Left := StrToInt(ImageXEdit.Text);
  Modify;
end;

procedure TVisVespASetupForm.ImageYEditChange(Sender: TObject);
begin
  if (NotLoaded) or (ImageYEdit.Text='') then exit;
  M.ImageObj.Top := StrToInt(ImageYEdit.Text);
  Modify;
end;

procedure TVisVespASetupForm.ImageSXEditChange(Sender: TObject);
begin
  if (NotLoaded) or (ImageSXEdit.Text='') then exit;
  M.ImageObj.Width := StrToInt(ImageSXEdit.Text);
  Modify;
end;

procedure TVisVespASetupForm.ImageSYEditChange(Sender: TObject);
begin
  if (NotLoaded) or (ImageSYEdit.Text='') then exit;
  M.ImageObj.Height := StrToInt(ImageSYEdit.Text);
  Modify;
end;

procedure TVisVespASetupForm.btOpenPicClick(Sender: TObject);
var
  Dlg: TOpenPictureDialog;
begin
  Dlg := TOpenPictureDialog.Create(nil);
  Dlg.InitialDir := VisImagesPath + M.ImagePic;
  Dlg.Options := Dlg.Options + [ofNoChangeDir];
  if Dlg.Execute then begin
    PicNameEdit.Text := ExtractFileName( Dlg.FileName );

    M.ImagePic := PicNameEdit.Text;

    ImageView.Picture.LoadFromFile(Dlg.FileName);
    M.ImageObj.Picture.LoadFromFile(Dlg.FileName);
    ImagePanel.Color := clBtnFace;


//    ShowMessage(IntToStr(M.ImageObj.Picture.Width));
    udImageSX.Position := M.ImageObj.Picture.Width;
    udImageSY.Position := M.ImageObj.Picture.Height;
    SetImageSize;

    Modify;
  end;
//    SetValue(ExtractFileName(Dlg.FileName));
  Dlg.Free;
end;

procedure TVisVespASetupForm.SetImageSize;
var
  x,y,sx,sy,ix,iy: integer;
begin
  ix := ImagePanel.Width-1;
  iy := ImagePanel.Height-1;
  sx := M.ImageObj.Picture.Width;
  sy := M.ImageObj.Picture.Height;

  if sx>ix then begin
    sy := sy*ix div sx;
    sx := ix;
  end;

  if sy>iy then begin
    sx := sx*iy div sy;
    sy := iy;
  end;

  x := (ix-sx) div 2;
  y := (iy-sy) div 2;

  ImageView.Left := x;
  ImageView.Top := y;
  ImageView.Width := sx;
  ImageView.Height := sy;

end;

procedure TVisVespASetupForm.TimerTimer(Sender: TObject);
var
  s: string;
  k: integer;
begin
  for k:=0 to M.DatCount-1 do
    if k = DatList.ItemIndex then begin
      if M.Datchik[k].Shape.Brush.Color <> clLime then
        M.Datchik[k].Shape.Brush.Color := clLime
      else
        M.Datchik[k].Shape.Brush.Color := clAqua;
    end else begin
      if M.Datchik[k].Shape.Brush.Color <> clAqua then
        M.Datchik[k].Shape.Brush.Color := clAqua;
    end;

  if cbImageAnim.Checked then begin
    s := trim(M.ImagePic);
    if length(s) > 0 then begin
      inc(ImageAnimNum);
      if (ImageAnimNum > 4) or (ImageAnimNum < 1) then ImageAnimNum := 1;
      try
        k := pos('_',s);
        if k=0 then raise Exception.Create('');
        delete(s, k, 2);
        insert(format('_%d',[ImageAnimNum]), s, k);
        s := VisImagesPath + s;

        ImageView.Picture.LoadFromFile(s);
        ImagePanel.Color := clBtnFace;
      except
        ImagePanel.Color := clRed;
      end;
    end;
  end;
end;

procedure TVisVespASetupForm.btImageResetClick(Sender: TObject);
begin
  udImageSX.Position := M.ImageObj.Picture.Width;
  udImageSY.Position := M.ImageObj.Picture.Height;
end;




procedure TVisVespASetupForm.DatNameEditChange(Sender: TObject);
begin
  if NotLoaded then exit;
  if (DatList.ItemIndex >= 0) and (DatList.ItemIndex < M.DatCount) then begin
    M.Datchik[DatList.ItemIndex].Name := DatNameEdit.Text;
    DatList.Items.Strings[DatList.ItemIndex] := DatNameEdit.Text;
    D.Designer.Modified;
  end;
end;

procedure TVisVespASetupForm.DatTagPostfixEditChange(Sender: TObject);
begin
  if NotLoaded then exit;
  if (DatList.ItemIndex >= 0) and (DatList.ItemIndex < M.DatCount) then begin
    M.Datchik[DatList.ItemIndex].TagPostfix := DatTagPostfixEdit.Text;
    D.Designer.Modified;
  end;
end;

procedure TVisVespASetupForm.cmbDatFormChange(Sender: TObject);
begin
  if NotLoaded then exit;
  if (DatList.ItemIndex >= 0) and (DatList.ItemIndex < M.DatCount) then begin
    M.Datchik[DatList.ItemIndex].Shape.Shape :=
        TShapeType(cmbDatForm.ItemIndex);
    D.Designer.Modified;
  end;
end;

procedure TVisVespASetupForm.cmbDatColorChange(Sender: TObject);
begin
  if NotLoaded then exit;
  if (DatList.ItemIndex >= 0) and (DatList.ItemIndex < M.DatCount) then begin
    M.Datchik[DatList.ItemIndex].ColorScheme := cmbDatColor.ItemIndex;
    D.Designer.Modified;
  end;
end;


procedure TVisVespASetupForm.DatXEditChange(Sender: TObject);
begin
  if (NotLoaded) or (DatXEdit.Text='') then exit;
  if (DatList.ItemIndex >= 0) and (DatList.ItemIndex < M.DatCount) then begin
    M.Datchik[DatList.ItemIndex].Shape.Left := StrToInt(DatXEdit.Text);
    D.Designer.Modified;
  end;
end;

procedure TVisVespASetupForm.DatYEditChange(Sender: TObject);
begin
  if (NotLoaded) or (DatYEdit.Text='') then exit;
  if (DatList.ItemIndex >= 0) and (DatList.ItemIndex < M.DatCount) then begin
    M.Datchik[DatList.ItemIndex].Shape.Top := StrToInt(DatYEdit.Text);
    D.Designer.Modified;
  end;
end;

procedure TVisVespASetupForm.DatSXEditChange(Sender: TObject);
begin
  if (NotLoaded) or (DatSXEdit.Text='') then exit;
  if (DatList.ItemIndex >= 0) and (DatList.ItemIndex < M.DatCount) then begin
    M.Datchik[DatList.ItemIndex].Shape.Width := StrToInt(DatSXEdit.Text);
    D.Designer.Modified;
  end;
end;

procedure TVisVespASetupForm.DatSYEditChange(Sender: TObject);
begin
  if (NotLoaded) or (DatSYEdit.Text='') then exit;
  if (DatList.ItemIndex >= 0) and (DatList.ItemIndex < M.DatCount) then begin
    M.Datchik[DatList.ItemIndex].Shape.Height := StrToInt(DatSYEdit.Text);
    D.Designer.Modified;
  end;
end;

procedure TVisVespASetupForm.btDatAddClick(Sender: TObject);
var
  k: integer;
begin
  k := M.DatCount;
  M.DatCount := M.DatCount + 1;
  SetLength(M.Datchik, M.DatCount);

  new(M.Datchik[k]);
  M.Datchik[k].Shape := TShape.Create(M);
  M.Datchik[k].Shape.Parent := M;
  M.Datchik[k].Shape.Visible := true;
  M.Datchik[k].Shape.Brush.Color := clAqua;
//  M.Datchik[k].Shape.OnMouseUp := M.OnDeviceMouseUp;
  M.Datchik[k].Shape.Left := 0;
  M.Datchik[k].Shape.Top := 0;
  M.Datchik[k].Shape.Width := 5;
  M.Datchik[k].Shape.Height := 5;
  M.Datchik[k].Shape.Shape := stRectangle;
  M.Datchik[k].ColorScheme := 0;
  M.Datchik[k].TagPostfix := '---';
  M.Datchik[k].Name := '';


  DatList.Items.Add('');
  DatList.ItemIndex := DatList.Items.Count-1;
  DatListClick(nil);
  D.Designer.Modified;
end;

procedure TVisVespASetupForm.btDatDelClick(Sender: TObject);
var
  i,k: integer;
begin
  k := DatList.ItemIndex;
  if (k>=0) and (k<M.DatCount) then begin
    M.Datchik[k].Shape.Free;
    dispose(M.Datchik[k]);

    for i:=k to M.DatCount-2 do M.Datchik[i] := M.Datchik[i+1];
    M.DatCount := M.DatCount-1;
    SetLength(M.Datchik, M.DatCount);

    DatList.Items.Delete(k);
    if k = DatList.Items.Count then Dec(k);
    DatList.ItemIndex := k;
    DatListClick(nil);
    D.Designer.Modified;
  end;
end;




end.
