unit VisZDVASetup;

interface

uses
  ExtDlgs, inifiles, Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, VisZDVA, Mask, ExtCtrls, Buttons, ComCtrls;

type
  TVisZDVASetupForm = class(TForm)
    Panel1: TPanel;
    DeviceNameEdit: TMaskEdit;
    Label1: TLabel;
    Label2: TLabel;
    LabelEdit: TMaskEdit;
    Label3: TLabel;
    TagNameEdit: TMaskEdit;
    TagPathEdit: TMaskEdit;
    Label4: TLabel;
    Panel2: TPanel;
    PicNameEdit: TMaskEdit;
    Label9: TLabel;
    ImageSXEdit: TEdit;
    ImageSYEdit: TEdit;
    Label10: TLabel;
    Label11: TLabel;
    udImageSY: TUpDown;
    udImageSX: TUpDown;
    Panel3: TPanel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    MainXEdit: TEdit;
    MainYEdit: TEdit;
    udMainY: TUpDown;
    udMainX: TUpDown;
    MainSXEdit: TEdit;
    MainSYEdit: TEdit;
    udMainSY: TUpDown;
    udMainSX: TUpDown;
    Label12: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    Panel4: TPanel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    Label27: TLabel;
    LabelXEdit: TEdit;
    LabelYEdit: TEdit;
    udLabelY: TUpDown;
    udLabelX: TUpDown;
    OkButton: TBitBtn;
    CancelButton: TBitBtn;
    ImagePanel: TPanel;
    ImageView: TImage;
    btImageReset: TSpeedButton;
    Panel6: TPanel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label35: TLabel;
    Label36: TLabel;
    Label37: TLabel;
    Label38: TLabel;
    edBlokX: TEdit;
    edBlokY: TEdit;
    udBlokY: TUpDown;
    udBlokX: TUpDown;
    edBlokSX: TEdit;
    edBlokSY: TEdit;
    udBlokSY: TUpDown;
    udBlokSX: TUpDown;
    Panel7: TPanel;
    Label33: TLabel;
    edStateMid: TEdit;
    edStateOpen: TEdit;
    Label30: TLabel;
    Panel5: TPanel;
    Label5: TLabel;
    Label24: TLabel;
    Label25: TLabel;
    Label26: TLabel;
    Label28: TLabel;
    Label29: TLabel;
    Label34: TLabel;
    edControlX: TEdit;
    edControlY: TEdit;
    udControlY: TUpDown;
    udControlX: TUpDown;
    edControlSX: TEdit;
    edControlSY: TEdit;
    udControlSY: TUpDown;
    udControlSX: TUpDown;
    Label31: TLabel;
    edStateClose: TEdit;
    Label32: TLabel;
    Panel8: TPanel;
    edChnlOutNum: TEdit;
    udChnlOutNum: TUpDown;
    Label39: TLabel;
    edChnlInNum: TEdit;
    udChnlInNum: TUpDown;
    Label40: TLabel;
    Label41: TLabel;
    Label42: TLabel;
    Label43: TLabel;
    ImageXEdit: TEdit;
    ImageYEdit: TEdit;
    udImageY: TUpDown;
    udImageX: TUpDown;
    Label44: TLabel;
    edNumber: TMaskEdit;
    cbFramesWithLabel: TCheckBox;
    procedure DeviceNameEditChange(Sender: TObject);
    procedure LabelEditChange(Sender: TObject);
    procedure TagPathEditChange(Sender: TObject);
    procedure TagNameEditChange(Sender: TObject);
    procedure MainYEditChange(Sender: TObject);
    procedure MainSXEditChange(Sender: TObject);
    procedure MainSYEditChange(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure LabelXEditChange(Sender: TObject);
    procedure LabelYEditChange(Sender: TObject);
    procedure ImageSXEditChange(Sender: TObject);
    procedure ImageSYEditChange(Sender: TObject);
    procedure btOpenPicClick(Sender: TObject);
    procedure btImageResetClick(Sender: TObject);
    procedure MainXEditChange(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure edBlokXChange(Sender: TObject);
    procedure edBlokYChange(Sender: TObject);
    procedure edBlokSXChange(Sender: TObject);
    procedure edBlokSYChange(Sender: TObject);
    procedure edStateMidChange(Sender: TObject);
    procedure edStateOpenChange(Sender: TObject);
    procedure edStateCloseChange(Sender: TObject);
    procedure edChnlOutNumChange(Sender: TObject);
    procedure edChnlInNumChange(Sender: TObject);
    procedure edControlSXChange(Sender: TObject);
    procedure edControlSYChange(Sender: TObject);
    procedure edControlXChange(Sender: TObject);
    procedure edControlYChange(Sender: TObject);
    procedure ImageXEditChange(Sender: TObject);
    procedure ImageYEditChange(Sender: TObject);
    procedure edNumberChange(Sender: TObject);
    procedure OkButtonClick(Sender: TObject);
  private
    NotLoaded: boolean;
//    ImageAnimNum: integer;
    procedure Modify;
    procedure SetImageSize;
  public
    M: TVisZDVA;
    D: TVisZDVAEditor;

  end;

var
  VisZDVASetupForm: TVisZDVASetupForm;

implementation
uses
  RpVisualUtils,
  RpVisualGlobal,
  HyperStr;

{$R *.DFM}

procedure TVisZDVASetupForm.FormActivate(Sender: TObject);
var
  s: string;
begin
  DeviceNameEdit.Text := M.DeviceName;
  TagPathEdit.Text := M.TagPath;
  TagNameEdit.Text := M.TagName;
  LabelEdit.Text := M.LabelObj.Caption;
  edNumber.Text := RestoreNumberText(TagNameEdit.Text, LabelEdit.Text);
  edNumber.OnChange := edNumberChange;

  udMainX.Position := M.Left;
  udMainY.Position := M.Top;
  udMainSX.Position := M.Width;
  udMainSY.Position := M.Height;

  udLabelX.Position := M.LabelObj.Left;
  udLabelY.Position := M.LabelObj.Top;

  udControlX.Position := M.FrameModeObj.Left;
  udControlY.Position := M.FrameModeObj.Top;
  udControlSX.Position := M.FrameModeObj.Width;
  udControlSY.Position := M.FrameModeObj.Height;

  udBlokX.Position := M.FrameBlokObj.Left;
  udBlokY.Position := M.FrameBlokObj.Top;
  udBlokSX.Position := M.FrameBlokObj.Width;
  udBlokSY.Position := M.FrameBlokObj.Height;

  udChnlOutNum.Position := M.ChnlOutNum;
  udChnlInNum.Position := M.ChnlInNum;

  edStateMid.Text := M.StateMid;
  edStateOpen.Text := M.StateOpen;
  edStateClose.Text := M.StateClose;

  PicNameEdit.Text := M.ImagePic;
  udImageX.Position := M.ImageObj.Left;
  udImageY.Position := M.ImageObj.Top;
  udImageSX.Position := M.ImageObj.Width;
  udImageSY.Position := M.ImageObj.Height;

  s := VisImagesPath + M.ImagePic;
  try
    if FileExists(s) then ImageView.Picture.LoadFromFile(s);
    SetImageSize;
    ImagePanel.Color := clBtnFace;
  except
    ImagePanel.Color := clRed;
  end;

  NotLoaded := false;

  edNumber.SetFocus;
  edNumber.SelectAll;
end;


procedure TVisZDVASetupForm.FormCreate(Sender: TObject);
begin
  NotLoaded := true;
  with TIniFile.Create(GetCurrentDir + '\VisScada.ini') do begin
    Left := ReadInteger('VisZDVA', 'Left', 6);
    Top := ReadInteger('VisZDVA', 'Top', 4);
    cbFramesWithLabel.Checked := ReadBool('VisZDVA', 'FramesWithLabel', false);
    Free;
  end;
end;

procedure TVisZDVASetupForm.FormDestroy(Sender: TObject);
begin
  with TIniFile.Create(GetCurrentDir + '\VisScada.ini') do begin
    WriteInteger('VisZDVA', 'Left', Left);
    WriteInteger('VisZDVA', 'Top', Top);
    WriteBool('VisZDVA', 'FramesWithLabel', cbFramesWithLabel.Checked);
    Free;
  end;
end;


procedure TVisZDVASetupForm.Modify;
begin
  M.Left := M.Left + 1;
  M.Left := M.Left - 1;
  D.Designer.Modified;
end;

procedure TVisZDVASetupForm.DeviceNameEditChange(Sender: TObject);
begin
  if NotLoaded then exit;
  M.DeviceName := DeviceNameEdit.Text;
  D.Designer.Modified;
end;

procedure TVisZDVASetupForm.LabelEditChange(Sender: TObject);
var
  d: Integer;
begin
  if NotLoaded then exit;
  d := M.LabelObj.Width;
  M.LabelObj.Caption := LabelEdit.Text;
  if cbFramesWithLabel.Checked then begin
    d := M.LabelObj.Width - d;
    udControlSX.Position := udControlSX.Position + d;
    udBlokSX.Position := udBlokSX.Position + d;
  end;
  Modify;
end;

procedure TVisZDVASetupForm.TagPathEditChange(Sender: TObject);
begin
  if NotLoaded then exit;
  M.TagPath := TagPathEdit.Text;
  D.Designer.Modified;
end;

procedure TVisZDVASetupForm.TagNameEditChange(Sender: TObject);
begin
  if NotLoaded then exit;
  M.TagName := TagNameEdit.Text;
  D.Designer.Modified;
end;

procedure TVisZDVASetupForm.MainXEditChange(Sender: TObject);
begin
  if (NotLoaded) or (MainXEdit.Text='') then exit;
  M.Left := CleanStrToIntDef(MainXEdit.Text, 0);
  D.Designer.Modified;
end;

procedure TVisZDVASetupForm.MainYEditChange(Sender: TObject);
begin
  if (NotLoaded) or (MainYEdit.Text='') then exit;
  M.Top := CleanStrToIntDef(MainYEdit.Text, 0);
  D.Designer.Modified;
end;

procedure TVisZDVASetupForm.MainSXEditChange(Sender: TObject);
begin
  if (NotLoaded) or (MainSXEdit.Text='') then exit;
  M.Width := CleanStrToIntDef(MainSXEdit.Text, 10);
  D.Designer.Modified;
end;

procedure TVisZDVASetupForm.MainSYEditChange(Sender: TObject);
begin
  if (NotLoaded) or (MainSYEdit.Text='') then exit;
  M.Height := CleanStrToIntDef(MainSYEdit.Text, 10);
  D.Designer.Modified;
end;


procedure TVisZDVASetupForm.LabelXEditChange(Sender: TObject);
var
  v, d: integer;
begin
  if (NotLoaded) or (LabelXEdit.Text='') then
    exit;

  v := CleanStrToIntDef(LabelXEdit.Text, 0);

  if cbFramesWithLabel.Checked then begin
    d := v - M.LabelObj.Left;
    udControlX.Position := udControlX.Position + d;
    udBlokX.Position := udBlokX.Position + d;
  end;

  M.LabelObj.Left := v;
  Modify;
end;

procedure TVisZDVASetupForm.LabelYEditChange(Sender: TObject);
var
  v, d: integer;
begin
  if (NotLoaded) or (LabelYEdit.Text='') then
    exit;

  v := CleanStrToIntDef(LabelYEdit.Text, 0);

  if cbFramesWithLabel.Checked then begin
    d := v - M.LabelObj.Top;
    udControlY.Position := udControlY.Position + d;
    udBlokY.Position := udBlokY.Position + d;
  end;

  M.LabelObj.Top := v;
  Modify;

//  if (NotLoaded) or (LabelXEdit.Text='') then exit;
//  M.LabelObj.Top := StrToInt(LabelYEdit.Text);
//  Modify;
end;

procedure TVisZDVASetupForm.ImageSXEditChange(Sender: TObject);
begin
  if (NotLoaded) or (ImageSXEdit.Text='') then exit;
  M.ImageObj.Width := CleanStrToIntDef(ImageSXEdit.Text, 0);
  Modify;
end;

procedure TVisZDVASetupForm.ImageSYEditChange(Sender: TObject);
begin
  if (NotLoaded) or (ImageSYEdit.Text='') then exit;
  M.ImageObj.Height := CleanStrToIntDef(ImageSYEdit.Text, 0);
  Modify;
end;

procedure TVisZDVASetupForm.ImageXEditChange(Sender: TObject);
begin
  if (NotLoaded) or (ImageXEdit.Text='') then exit;
  M.ImageObj.Left := CleanStrToIntDef(ImageXEdit.Text, 0);
  Modify;
end;

procedure TVisZDVASetupForm.ImageYEditChange(Sender: TObject);
begin
  if (NotLoaded) or (ImageYEdit.Text='') then exit;
  M.ImageObj.Top := CleanStrToIntDef(ImageYEdit.Text, 0);
  Modify;
end;


// Blok Frames
procedure TVisZDVASetupForm.edBlokXChange(Sender: TObject);
begin
  if (NotLoaded) or (edBlokX.Text='') then exit;
  M.FrameBlokObj.Left := CleanStrToIntDef(edBlokX.Text, 0);
  Modify;
end;

procedure TVisZDVASetupForm.edBlokYChange(Sender: TObject);
begin
  if (NotLoaded) or (edBlokY.Text='') then exit;
  M.FrameBlokObj.Top := CleanStrToIntDef(edBlokY.Text, 0);
  Modify;
end;

procedure TVisZDVASetupForm.edBlokSXChange(Sender: TObject);
begin
  if (NotLoaded) or (edBlokSX.Text='') then exit;
  M.FrameBlokObj.Width := CleanStrToIntDef(edBlokSX.Text, 0);
  Modify;
end;

procedure TVisZDVASetupForm.edBlokSYChange(Sender: TObject);
begin
  if (NotLoaded) or (edBlokSY.Text='') then exit;
  M.FrameBlokObj.Height := CleanStrToIntDef(edBlokSY.Text, 0);
  Modify;
end;


// Control Frames
procedure TVisZDVASetupForm.edControlXChange(Sender: TObject);
begin
  if (NotLoaded) or (edControlX.Text='') then exit;
  M.FrameModeObj.Left := CleanStrToIntDef(edControlX.Text, 0);
  Modify;
end;

procedure TVisZDVASetupForm.edControlYChange(Sender: TObject);
begin
  if (NotLoaded) or (edControlY.Text='') then exit;
  M.FrameModeObj.Top := CleanStrToIntDef(edControlY.Text, 0);
  Modify;
end;

procedure TVisZDVASetupForm.edControlSXChange(Sender: TObject);
begin
  if (NotLoaded) or (edControlSX.Text='') then exit;
  M.FrameModeObj.Width := CleanStrToIntDef(edControlSX.Text, 0);
  Modify;
end;

procedure TVisZDVASetupForm.edControlSYChange(Sender: TObject);
begin
  if (NotLoaded) or (edControlSY.Text='') then exit;
  M.FrameModeObj.Height := CleanStrToIntDef(edControlSY.Text, 0);
  Modify;
end;




// Control state name
procedure TVisZDVASetupForm.edStateMidChange(Sender: TObject);
begin
  if (NotLoaded) then exit;
  M.StateMid := edStateMid.Text;
  Modify;
end;

procedure TVisZDVASetupForm.edStateOpenChange(Sender: TObject);
begin
  if (NotLoaded) then exit;
  M.StateOpen := edStateOpen.Text;
  Modify;
end;

procedure TVisZDVASetupForm.edStateCloseChange(Sender: TObject);
begin
  if (NotLoaded) then exit;
  M.StateClose := edStateClose.Text;
  Modify;
end;



procedure TVisZDVASetupForm.btOpenPicClick(Sender: TObject);
var
  Dlg: TOpenPictureDialog;

begin
  Dlg := TOpenPictureDialog.Create(nil);
  Dlg.Filter := '(*_1.*)|*_1.*|(*.*)|*.*';
  Dlg.InitialDir := ExtractFilePath(VisImagesPath + M.ImagePic);

  Dlg.Options := Dlg.Options + [ofNoChangeDir];
  if Dlg.Execute then begin
    if Pos( UpperCase(VisImagesPath), UpperCase(Dlg.FileName) ) > 0 then begin
      PicNameEdit.Text := copy(Dlg.FileName, Length(VisImagesPath)+1, Length(Dlg.FileName) );
    end else
      PicNameEdit.Text := ExtractFileName( Dlg.FileName );

    M.ImagePic := PicNameEdit.Text;

    ImageView.Picture.LoadFromFile(Dlg.FileName);
    M.ImageObj.Picture.LoadFromFile(Dlg.FileName);
    ImagePanel.Color := clBtnFace;

    udImageSX.Position := M.ImageObj.Picture.Width;
    udImageSY.Position := M.ImageObj.Picture.Height;
    SetImageSize;

    Modify;
  end;
  Dlg.Free;
end;
  
{
begin
  Dlg := TOpenPictureDialog.Create(nil);
  Dlg.InitialDir := VisImagesPath + M.ImagePic;
  Dlg.Options := Dlg.Options + [ofNoChangeDir];
  if Dlg.Execute then begin
    PicNameEdit.Text := ExtractFileName( Dlg.FileName );

    M.ImagePic := PicNameEdit.Text;

    ImageView.Picture.LoadFromFile(Dlg.FileName);

    M.ImageObj.Picture.LoadFromFile(Dlg.FileName);

    ImagePanel.Color := clBtnFace;

    udImageSX.Position := ImageView.Picture.Width;
    udImageSY.Position := ImageView.Picture.Height;
    SetImageSize;

    Modify;
  end;
  Dlg.Free;
end;
}

procedure TVisZDVASetupForm.SetImageSize;
var
  x,y,sx,sy,ix,iy: integer;
begin

  ix := ImagePanel.Width-1;
  iy := ImagePanel.Height-1;
  sx := M.ImageObj.Picture.Width;
  sy := M.ImageObj.Picture.Height;

  if sx>ix then begin
    sy := sy*ix div sx;
    sx := ix;
  end;

  if sy>iy then begin
    sx := sx*iy div sy;
    sy := iy;
  end;

  x := (ix-sx) div 2;
  y := (iy-sy) div 2;

  ImageView.Left := x;
  ImageView.Top := y;
  ImageView.Width := sx;
  ImageView.Height := sy;

end;

procedure TVisZDVASetupForm.btImageResetClick(Sender: TObject);
begin
  udImageSX.Position := M.ImageObj.Picture.Width;
  udImageSY.Position := M.ImageObj.Picture.Height;
end;





procedure TVisZDVASetupForm.edChnlOutNumChange(Sender: TObject);
begin
  if (NotLoaded) or (edChnlOutNum.Text='') then exit;
  M.ChnlOutNum := CleanStrToIntDef(edChnlOutNum.Text, 0);
  Modify;
end;

procedure TVisZDVASetupForm.edChnlInNumChange(Sender: TObject);
begin
  if (NotLoaded) or (edChnlInNum.Text='') then exit;
  M.ChnlInNum := CleanStrToIntDef(edChnlInNum.Text, 0);
  Modify;
end;


procedure TVisZDVASetupForm.edNumberChange(Sender: TObject);

  function _repl(src, s: string; no_leading_zeros: boolean = false): string;
  var
    k: integer;
  begin
    if no_leading_zeros then begin
      while pos('0', s)=1 do
        delete(s, 1, 1);
    end;

    k := pos(' ', src);
    if k>0 then
      src := s + copy(src, k, length(src)-k+1)
    else
      src := s;
    result := src;
  end;

var
  s: string;
begin
  s := Trim(edNumber.Text);
  ReplaceS(s, '.', '_');
  TagNameEdit.Text := s;

  DeviceNameEdit.Text := _repl(DeviceNameEdit.Text, edNumber.Text, true);
  LabelEdit.Text := _repl(LabelEdit.Text, edNumber.Text, true);

  DeviceNameEdit.Text:=StringReplace(DeviceNameEdit.Text,'_','.',[rfReplaceAll,rfIgnoreCase]);
  LabelEdit.Text:=StringReplace(LabelEdit.Text,'_','.',[rfReplaceAll,rfIgnoreCase]);
end;


procedure TVisZDVASetupForm.OkButtonClick(Sender: TObject);
begin
  M.RepaintRect();
  ModalResult := mrOk;
end;

end.
