unit VisZDVBSetup;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, VisZDVB, Mask, ExtCtrls, Buttons, ComCtrls, RpVisualGlobal;

type
  TVisZDVBSetupForm = class(TForm)
    Panel1: TPanel;
    DeviceNameEdit: TMaskEdit;
    Label1: TLabel;
    Label2: TLabel;
    LabelEdit: TMaskEdit;
    Label3: TLabel;
    TagNameEdit: TMaskEdit;
    TagPathEdit: TMaskEdit;
    Label4: TLabel;
    Panel2: TPanel;
    PicNameEdit: TMaskEdit;
    Label9: TLabel;
    ImageSXEdit: TEdit;
    ImageSYEdit: TEdit;
    Label10: TLabel;
    Label11: TLabel;
    udImageSY: TUpDown;
    udImageSX: TUpDown;
    Panel3: TPanel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    MainXEdit: TEdit;
    MainYEdit: TEdit;
    udMainY: TUpDown;
    udMainX: TUpDown;
    MainSXEdit: TEdit;
    MainSYEdit: TEdit;
    udMainSY: TUpDown;
    udMainSX: TUpDown;
    Label12: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    Panel4: TPanel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    Label27: TLabel;
    LabelXEdit: TEdit;
    LabelYEdit: TEdit;
    udLabelY: TUpDown;
    udLabelX: TUpDown;
    OkButton: TBitBtn;
    CancelButton: TBitBtn;
    ImagePanel: TPanel;
    ImageView: TImage;
    Timer: TTimer;
    cbImageAnim: TCheckBox;
    btImageReset: TSpeedButton;
    Panel6: TPanel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label35: TLabel;
    Label36: TLabel;
    Label37: TLabel;
    Label38: TLabel;
    edBlokX: TEdit;
    edBlokY: TEdit;
    udBlokY: TUpDown;
    udBlokX: TUpDown;
    edBlokSX: TEdit;
    edBlokSY: TEdit;
    udBlokSY: TUpDown;
    udBlokSX: TUpDown;
    Panel7: TPanel;
    Label33: TLabel;
    edStateMid: TEdit;
    edStateOpen: TEdit;
    Label30: TLabel;
    Panel5: TPanel;
    Label5: TLabel;
    Label24: TLabel;
    Label25: TLabel;
    Label26: TLabel;
    Label28: TLabel;
    Label29: TLabel;
    Label34: TLabel;
    edControlX: TEdit;
    edControlY: TEdit;
    udControlY: TUpDown;
    udControlX: TUpDown;
    edControlSX: TEdit;
    edControlSY: TEdit;
    udControlSY: TUpDown;
    udControlSX: TUpDown;
    Label31: TLabel;
    edStateClose: TEdit;
    Label32: TLabel;
    Panel8: TPanel;
    edChnlOutNum: TEdit;
    udChnlOutNum: TUpDown;
    Label39: TLabel;
    edChnlInNum: TEdit;
    udChnlInNum: TUpDown;
    Label40: TLabel;
    Label41: TLabel;
    Label42: TLabel;
    Label43: TLabel;
    ImageXEdit: TEdit;
    ImageYEdit: TEdit;
    udImageY: TUpDown;
    udImageX: TUpDown;
    Label44: TLabel;
    edNumber: TMaskEdit;
    procedure DeviceNameEditChange(Sender: TObject);
    procedure LabelEditChange(Sender: TObject);
    procedure TagPathEditChange(Sender: TObject);
    procedure TagNameEditChange(Sender: TObject);
    procedure MainYEditChange(Sender: TObject);
    procedure MainSXEditChange(Sender: TObject);
    procedure MainSYEditChange(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure LabelXEditChange(Sender: TObject);
    procedure LabelYEditChange(Sender: TObject);
    procedure ImageSXEditChange(Sender: TObject);
    procedure ImageSYEditChange(Sender: TObject);
    procedure btOpenPicClick(Sender: TObject);
    procedure btImageResetClick(Sender: TObject);
    procedure MainXEditChange(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure edBlokXChange(Sender: TObject);
    procedure edBlokYChange(Sender: TObject);
    procedure edBlokSXChange(Sender: TObject);
    procedure edBlokSYChange(Sender: TObject);
    procedure edStateMidChange(Sender: TObject);
    procedure edStateOpenChange(Sender: TObject);
    procedure edStateCloseChange(Sender: TObject);
    procedure edChnlOutNumChange(Sender: TObject);
    procedure edChnlInNumChange(Sender: TObject);
    procedure edControlSXChange(Sender: TObject);
    procedure edControlSYChange(Sender: TObject);
    procedure edControlXChange(Sender: TObject);
    procedure edControlYChange(Sender: TObject);
    procedure ImageXEditChange(Sender: TObject);
    procedure ImageYEditChange(Sender: TObject);
    procedure edNumberChange(Sender: TObject);
  private
    NotLoaded: boolean;
//    ImageAnimNum: integer;
    procedure Modify;
    procedure SetImageSize;
  public
    M: TVisZDVB;
    D: TVisZDVBEditor;
    
  end;

var
  VisZDVBSetupForm: TVisZDVBSetupForm;

implementation
uses ExtDlgs, inifiles;

{$R *.DFM}

procedure TVisZDVBSetupForm.FormActivate(Sender: TObject);
var
  s: string;
begin
  DeviceNameEdit.Text := M.DeviceName;
  TagPathEdit.Text := M.TagPath;
  TagNameEdit.Text := M.TagName;
  LabelEdit.Text := M.LabelObj.Caption;

  udMainX.Position := M.Left;
  udMainY.Position := M.Top;
  udMainSX.Position := M.Width;
  udMainSY.Position := M.Height;

  udLabelX.Position := M.LabelObj.Left;
  udLabelY.Position := M.LabelObj.Top;

  udControlX.Position := M.FrameModeObj.Left;
  udControlY.Position := M.FrameModeObj.Top;
  udControlSX.Position := M.FrameModeObj.Width;
  udControlSY.Position := M.FrameModeObj.Height;

  udBlokX.Position := M.FrameBlokObj.Left;
  udBlokY.Position := M.FrameBlokObj.Top;
  udBlokSX.Position := M.FrameBlokObj.Width;
  udBlokSY.Position := M.FrameBlokObj.Height;

  udChnlOutNum.Position := M.ChnlOutNum;
  udChnlInNum.Position := M.ChnlInNum;

  edStateMid.Text := M.StateMid;
  edStateOpen.Text := M.StateOpen;
  edStateClose.Text := M.StateClose;

  PicNameEdit.Text := M.ImagePic;
  udImageX.Position := M.ImageObj.Left;
  udImageY.Position := M.ImageObj.Top;
  udImageSX.Position := M.ImageObj.Width;
  udImageSY.Position := M.ImageObj.Height;

  s := VisImagesPath + M.ImagePic;
  try
    if FileExists(s) then ImageView.Picture.LoadFromFile(s);
    SetImageSize;
    ImagePanel.Color := clBtnFace;
  except
    ImagePanel.Color := clRed;
  end;

  NotLoaded := false;

  edNumber.SetFocus;
end;


procedure TVisZDVBSetupForm.FormCreate(Sender: TObject);
begin
  NotLoaded := true;
  with TIniFile.Create(GetCurrentDir + '\VisScada.ini') do begin
    Left := ReadInteger('VisZDVB', 'Left', 6);
    Top := ReadInteger('VisZDVB', 'Top', 4);
    cbImageAnim.Checked := ReadBool('VisZDVB', 'ImageAnim', false);
    Free;
  end;
end;

procedure TVisZDVBSetupForm.FormDestroy(Sender: TObject);
begin
  with TIniFile.Create(GetCurrentDir + '\VisScada.ini') do begin
    WriteInteger('VisZDVB', 'Left', Left);
    WriteInteger('VisZDVB', 'Top', Top);
    WriteBool('VisZDVB', 'ImageAnim', cbImageAnim.Checked);
    Free;
  end;
end;


procedure TVisZDVBSetupForm.Modify;
begin
  M.Left := M.Left + 1;
  M.Left := M.Left - 1;
  D.Designer.Modified;
end;

procedure TVisZDVBSetupForm.DeviceNameEditChange(Sender: TObject);
begin
  if NotLoaded then exit;
  M.DeviceName := DeviceNameEdit.Text;
  D.Designer.Modified;
end;

procedure TVisZDVBSetupForm.LabelEditChange(Sender: TObject);
begin
  if NotLoaded then exit;
  M.LabelObj.Caption := LabelEdit.Text;
  Modify;
end;

procedure TVisZDVBSetupForm.TagPathEditChange(Sender: TObject);
begin
  if NotLoaded then exit;
  M.TagPath := TagPathEdit.Text;
  D.Designer.Modified;
end;

procedure TVisZDVBSetupForm.TagNameEditChange(Sender: TObject);
begin
  if NotLoaded then exit;
  M.TagName := TagNameEdit.Text;
  D.Designer.Modified;
end;

procedure TVisZDVBSetupForm.MainXEditChange(Sender: TObject);
begin
  if (NotLoaded) or (MainXEdit.Text='') then exit;
  M.Left := StrToInt(MainXEdit.Text);
  D.Designer.Modified;
end;

procedure TVisZDVBSetupForm.MainYEditChange(Sender: TObject);
begin
  if (NotLoaded) or (MainYEdit.Text='') then exit;
  M.Top := StrToInt(MainYEdit.Text);
  D.Designer.Modified;
end;

procedure TVisZDVBSetupForm.MainSXEditChange(Sender: TObject);
begin
  if (NotLoaded) or (MainSXEdit.Text='') then exit;
  M.Width := StrToInt(MainSXEdit.Text);
  D.Designer.Modified;
end;

procedure TVisZDVBSetupForm.MainSYEditChange(Sender: TObject);
begin
  if (NotLoaded) or (MainSYEdit.Text='') then exit;
  M.Height := StrToInt(MainSYEdit.Text);
  D.Designer.Modified;
end;


procedure TVisZDVBSetupForm.LabelXEditChange(Sender: TObject);
begin
  if (NotLoaded) or (LabelXEdit.Text='') then exit;
  M.LabelObj.Left := StrToInt(LabelXEdit.Text);
  Modify;
end;

procedure TVisZDVBSetupForm.LabelYEditChange(Sender: TObject);
begin
  if (NotLoaded) or (LabelXEdit.Text='') then exit;
  M.LabelObj.Top := StrToInt(LabelYEdit.Text);
  Modify;
end;

procedure TVisZDVBSetupForm.ImageSXEditChange(Sender: TObject);
begin
  if (NotLoaded) or (ImageSXEdit.Text='') then exit;
  M.ImageObj.Width := StrToInt(ImageSXEdit.Text);
  Modify;
end;

procedure TVisZDVBSetupForm.ImageSYEditChange(Sender: TObject);
begin
  if (NotLoaded) or (ImageSYEdit.Text='') then exit;
  M.ImageObj.Height := StrToInt(ImageSYEdit.Text);
  Modify;
end;

procedure TVisZDVBSetupForm.ImageXEditChange(Sender: TObject);
begin
  if (NotLoaded) or (ImageXEdit.Text='') then exit;
  M.ImageObj.Left := StrToInt(ImageXEdit.Text);
  Modify;
end;

procedure TVisZDVBSetupForm.ImageYEditChange(Sender: TObject);
begin
  if (NotLoaded) or (ImageYEdit.Text='') then exit;
  M.ImageObj.Top := StrToInt(ImageYEdit.Text);
  Modify;
end;


// Blok Frames
procedure TVisZDVBSetupForm.edBlokXChange(Sender: TObject);
begin
  if (NotLoaded) or (edBlokX.Text='') then exit;
  M.FrameBlokObj.Left := StrToInt(edBlokX.Text);
  Modify;
end;

procedure TVisZDVBSetupForm.edBlokYChange(Sender: TObject);
begin
  if (NotLoaded) or (edBlokY.Text='') then exit;
  M.FrameBlokObj.Top := StrToInt(edBlokY.Text);
  Modify;
end;

procedure TVisZDVBSetupForm.edBlokSXChange(Sender: TObject);
begin
  if (NotLoaded) or (edBlokSX.Text='') then exit;
  M.FrameBlokObj.Width := StrToInt(edBlokSX.Text);
  Modify;
end;

procedure TVisZDVBSetupForm.edBlokSYChange(Sender: TObject);
begin
  if (NotLoaded) or (edBlokSY.Text='') then exit;
  M.FrameBlokObj.Height := StrToInt(edBlokSY.Text);
  Modify;
end;


// Control Frames
procedure TVisZDVBSetupForm.edControlXChange(Sender: TObject);
begin
  if (NotLoaded) or (edControlX.Text='') then exit;
  M.FrameModeObj.Left := StrToInt(edControlX.Text);
  Modify;
end;

procedure TVisZDVBSetupForm.edControlYChange(Sender: TObject);
begin
  if (NotLoaded) or (edControlY.Text='') then exit;
  M.FrameModeObj.Top := StrToInt(edControlY.Text);
  Modify;
end;

procedure TVisZDVBSetupForm.edControlSXChange(Sender: TObject);
begin
  if (NotLoaded) or (edControlSX.Text='') then exit;
  M.FrameModeObj.Width := StrToInt(edControlSX.Text);
  Modify;
end;

procedure TVisZDVBSetupForm.edControlSYChange(Sender: TObject);
begin
  if (NotLoaded) or (edControlSY.Text='') then exit;
  M.FrameModeObj.Height := StrToInt(edControlSY.Text);
  Modify;
end;




// Control state name
procedure TVisZDVBSetupForm.edStateMidChange(Sender: TObject);
begin
  if (NotLoaded) then exit;
  M.StateMid := edStateMid.Text;
  Modify;
end;

procedure TVisZDVBSetupForm.edStateOpenChange(Sender: TObject);
begin
  if (NotLoaded) then exit;
  M.StateOpen := edStateOpen.Text;
  Modify;
end;

procedure TVisZDVBSetupForm.edStateCloseChange(Sender: TObject);
begin
  if (NotLoaded) then exit;
  M.StateClose := edStateClose.Text;
  Modify;
end;



procedure TVisZDVBSetupForm.btOpenPicClick(Sender: TObject);
var
  Dlg: TOpenPictureDialog;
begin
  Dlg := TOpenPictureDialog.Create(nil);
  Dlg.InitialDir := VisImagesPath + M.ImagePic;
  Dlg.Options := Dlg.Options + [ofNoChangeDir];
  if Dlg.Execute then begin
    PicNameEdit.Text := ExtractFileName( Dlg.FileName );

    M.ImagePic := PicNameEdit.Text;

    ImageView.Picture.LoadFromFile(Dlg.FileName);

    M.ImageObj.Picture.LoadFromFile(Dlg.FileName);

    ImagePanel.Color := clBtnFace;

    udImageSX.Position := ImageView.Picture.Width;
    udImageSY.Position := ImageView.Picture.Height;
    SetImageSize;

    Modify;
  end;
  Dlg.Free;
end;

procedure TVisZDVBSetupForm.SetImageSize;
var
  x,y,sx,sy,ix,iy: integer;
begin

  ix := ImagePanel.Width-1;
  iy := ImagePanel.Height-1;
  sx := M.ImageObj.Picture.Width;
  sy := M.ImageObj.Picture.Height;

  if sx>ix then begin
    sy := sy*ix div sx;
    sx := ix;
  end;

  if sy>iy then begin
    sx := sx*iy div sy;
    sy := iy;
  end;

  x := (ix-sx) div 2;
  y := (iy-sy) div 2;

  ImageView.Left := x;
  ImageView.Top := y;
  ImageView.Width := sx;
  ImageView.Height := sy;

end;

procedure TVisZDVBSetupForm.btImageResetClick(Sender: TObject);
begin
  udImageSX.Position := M.ImageObj.Picture.Width;
  udImageSY.Position := M.ImageObj.Picture.Height;
end;





procedure TVisZDVBSetupForm.edChnlOutNumChange(Sender: TObject);
begin
  if (NotLoaded) or (edChnlOutNum.Text='') then exit;
  M.ChnlOutNum := StrToInt(edChnlOutNum.Text);
  Modify;
end;

procedure TVisZDVBSetupForm.edChnlInNumChange(Sender: TObject);
begin
  if (NotLoaded) or (edChnlInNum.Text='') then exit;
  M.ChnlInNum := StrToInt(edChnlInNum.Text);
  Modify;
end;


procedure TVisZDVBSetupForm.edNumberChange(Sender: TObject);

  function _repl(src, s: string): string;
  var
    k: integer;
  begin
    k := pos(' ', src);
    if k>0 then
      src := s + copy(src, k, length(src)-k+1)
    else
      src := s;
    result := src;
  end;

begin
  TagNameEdit.Text := _repl(TagNameEdit.Text, edNumber.Text);
  DeviceNameEdit.Text := _repl(DeviceNameEdit.Text, edNumber.Text);
  LabelEdit.Text := _repl(LabelEdit.Text, edNumber.Text);
end;


end.
