// DEPRECATED !!!   .  !

unit VisZDVC;

interface

uses
{$ifdef VER150}
  DesignIntf, DesignEditors, DesignWindows, DsnConst,
{$else}
  DsgnIntf,
{$endif}
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, stdctrls, RpVisualGlobal, ScadaBase;


type

  TVisZDVC = class(TCustomScadaObject)
  private
    FTagName: TTagName;
    FDeviceName: TDeviceName;
    FChnlNumber: integer;

    //  
    FImage: TImage;
    FImageX: integer;
    FImageY: integer;
    FImageXLen: integer;
    FImageYLen: integer;
    FImagePic: TPicName;

    //  
    FLabel: TLabel;
    FLabelX: integer;
    FLabelY: integer;
    FLabelText: TDeviceName;
    FFrameBlok: TShape;
    FFrameMode: TShape;

    //  
    procedure SetImageX(Value: integer);
    procedure SetImageY(Value: integer);
    procedure SetImageXLen(Value: integer);
    procedure SetImageYLen(Value: integer);
    procedure SetImagePic(Value: TPicName);

    //  
    procedure SetLabelX(Value: integer);
    procedure SetLabelY(Value: integer);
    procedure SetLabelText(Value: TDeviceName);

  protected
    FTagZdvcControl: integer;
    FTagZdvcSost: integer;
    FTagZdvcBlok: integer;

    procedure SetImageSost(Value: integer);
    procedure SetFrameMode(Value: integer);
    procedure SetFrameBlok(Value: integer);
  public
    ImageSost: integer;
    FrameMode: integer;
    FrameBlok: integer;

    constructor Create(AOwner: TComponent); override;
    procedure Init; override;
    procedure Process; override;

  published
    property TagName: TTagName read FTagName write FTagName;
    property DeviceName: TDeviceName read FDeviceName write FDeviceName;
    property ChnlNumber: integer read FChnlNumber write FChnlNumber;

    //  
    property ImageX: integer read FImageX write SetImageX;
    property ImageY: integer read FImageY write SetImageY;
    property ImageXLen: integer read FImageXLen write SetImageXLen;
    property ImageYLen: integer read FImageYLen write SetImageYLen;
    property ImagePic: TPicName read FImagePic write SetImagePic;

    //  
    property LabelX: integer read FLabelX write SetLabelX;
    property LabelY: integer read FLabelY write SetLabelY;
    property LabelText: TDeviceName read FLabelText write SetLabelText;

  end;

  TImageFilenameProperty = class(TPropertyEditor)
    function GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;
    function GetValue: string; override;
    procedure SetValue(const Value: string); override;
  end;


procedure Register;

implementation
uses
  TagStorage,
  ExtDlgs;

procedure Register;
begin
  RegisterComponents('Scada', [TVisZDVC]);
  RegisterPropertyEditor( TypeInfo(TPicName), TVisZDVC, 'ImagePic', TImageFilenameProperty );
end;

{ TVisZDVC }

constructor TVisZDVC.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FEraseBackground := true;
  Width := 100;
  Height := 100;
  ShowHint := true;

  FTagZdvcControl := -1;
  FTagZdvcSost := -1;
  FTagZdvcBlok  := -1;

  //  
  FImage := TImage.Create(Self);
  FImage.Parent := self;
  FImage.Stretch := true;
  FImage.Visible := true;

  //   Mode
  FFrameMode := TShape.Create(self);
  FFrameMode.Parent := self;
  FFrameMode.Visible := true;
  FFrameMode.Brush.Style := bsClear;
  FFrameMode.Pen.Color := clAqua;

  //   Blok
  FFrameBlok := TShape.Create(self);
  FFrameBlok.Parent := self;
  FFrameBlok.Visible := true;
  FFrameBlok.Brush.Style := bsClear;
  FFrameBlok.Pen.Color := clYellow;

  //  
  FLabel := TLabel.Create(Self);
  FLabel.Parent := self;
  FLabel.Visible := true;
  FLabel.Transparent := true;
  FLabel.Font.Color := clWhite;
  FLabel.Font.Size := 10;
  FLabel.Font.Style := [fsBold];
  FLabel.Font.Name := 'Tahoma';
  SetLabelText('');

  FImage.OnClick := OnDeviceClick;
  FLabel.OnClick := OnDeviceClick;

  ImageSost := -1;
  FrameMode := -1;
  FrameBlok := -1;
end;


procedure TVisZDVC.SetImageYLen(Value: integer);
begin
  FImageYLen := value;
  FImage.Height := value;
end;

procedure TVisZDVC.SetImageX(Value: integer);
begin
  FImageX := value;
  FImage.Left := value;
end;

procedure TVisZDVC.SetImageY(Value: integer);
begin
  FImageY := value;
  FImage.Top := value;
end;

procedure TVisZDVC.SetImageXLen(Value: integer);
begin
  FImageXLen := value;
  FImage.Width := value;
end;

procedure TVisZDVC.SetImagePic(Value: TPicName);
begin
  try
    FImage.Picture.LoadFromFile(VisImagesPath + Value);
    FImagePic := Value;
    ImageXLen := FImage.Picture.Width;
    ImageYLen := FImage.Picture.Height;
  except
  end;
end;

procedure TVisZDVC.SetImageSost(Value: integer);
var
  s: string;
  k: integer;
begin
  if Value <> ImageSost then try
    s := FImagePic;
    k := pos('.', s);
    if k > 0 then insert('_' + IntToStr(Value), s, k);
    s := VisImagesPath + s;

    if fileexists(s) then
      FImage.Picture.LoadFromFile(s);

    ImageSost := Value;
  except
    FLabel.Caption := 'PICT' + IntToStr(Value) + ' ERR!';
  end;
end;

procedure TVisZDVC.SetLabelText(Value: TDeviceName);
begin
  FLabelText := value;
  FLabel.Caption := value;

  FFrameMode.Left := FLabel.Left - ModeMarginX;
  FFrameMode.Top := FLabel.Top - ModeMarginY;
  FFrameMode.Width := FLabel.Width + 2*ModeMarginX;
  FFrameMode.Height := FLabel.Height + 2*ModeMarginY;

  FFrameBlok.Left := FLabel.Left - BlokMarginX;
  FFrameBlok.Top := FLabel.Top - BlokMarginY;
  FFrameBlok.Width := FLabel.Width + 2*BlokMarginX;
  FFrameBlok.Height := FLabel.Height + 2*BlokMarginY;
end;

procedure TVisZDVC.SetLabelX(Value: integer);
begin
  FLabelX := value;
  FLabel.Left := value;
  FFrameMode.Left := FLabel.Left - ModeMarginX;
  FFrameBlok.Left := FLabel.Left - BlokMarginX;
end;

procedure TVisZDVC.SetLabelY(Value: integer);
begin
  FLabelY := value;
  FLabel.Top := value;
  FFrameMode.Top := FLabel.Top - ModeMarginY;
  FFrameBlok.Top := FLabel.Top - BlokMarginY;
end;

procedure TVisZDVC.SetFrameMode(Value: integer);
begin
  if Value <> FrameMode then begin
    if (value) > 0 then
      FFrameMode.Pen.Color := clAqua
    else
      FFrameMode.Pen.Color := Color;
    FrameMode := Value;
  end;
end;

procedure TVisZDVC.SetFrameBlok(Value: integer);
begin
  if Value <> FrameBlok then begin
    if (value) > 0 then
      FFrameBlok.Pen.Color := clYellow
    else
      FFrameBlok.Pen.Color := Color;
    FrameBlok := Value;
  end;
end;


// INIT
procedure TVisZDVC.Init;
begin
  FTagZdvcControl := GetTagIndex(TagPath + '.ZDVC_' + FTagName + '_Control');
  FTagZdvcSost := GetTagIndex(TagPath + '.ZDVC_' + FTagName + '_Sost');
  FTagZdvcBlok := GetTagIndex(TagPath + '.ZDVC_' + FTagName + '_Blok');
  IsConnectionBad := (FTagZdvcSost<0) or (FTagZdvcControl<0) or (FTagZdvcBlok<0);
end;

// PROCESS HANDLER
procedure TVisZDVC.Process;
var
  value: integer;
begin
  value := GetTagValue(FTagZdvcSost);
  SetImageSost(value);
  IsValueBad := (value < 0);

  value := GetTagValue(FTagZdvcControl);
  SetFrameMode(value);
  IsValueBad := IsValueBad or (value < 0);

  value := GetTagValue(FTagZdvcBlok);
  SetFrameBlok(value);
  IsValueBad := IsValueBad or (value < 0);

  inherited;
end;


procedure TImageFilenameProperty.Edit;
var
  Dlg: TOpenPictureDialog;
begin
  inherited;
  Dlg := TOpenPictureDialog.Create(nil);
  Dlg.InitialDir := VisImagesPath;
  Dlg.Options := Dlg.Options + [ofNoChangeDir];
  if Dlg.Execute then
    SetValue(ExtractFileName(Dlg.FileName));

  Dlg.Free;
end;

function TImageFilenameProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog, paMultiSelect ];
end;

function TImageFilenameProperty.GetValue: string;
begin
  result := GetStrValue;
end;

procedure TImageFilenameProperty.SetValue(const Value: string);
begin
  SetStrValue(Value);
end;


end.
