// DEPRECATED !!!   .  !

unit VisZDVH;

interface

uses
{$ifdef VER150}
  DesignIntf, DesignEditors, DesignWindows, DsnConst,
{$else}
  DsgnIntf,
{$endif}
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, stdctrls, ScadaBase, RpVisualGlobal;


type
  PVisZDVHDir =^TVisZDVHDir;
  TVisZDVHDir = record
    Name: string[32];
    TagPostfix: string[8];
    ImageObj: TImage;
    FrameBlokObj: TShape;
    LabelObj: TLabel;
    TagIdxOpened: integer;
    TagIdxBlok: integer;
    valOpened: integer;
    valBlok: integer;
  end;

  TVisZDVH = class(TCustomScadaObject)
  private
    FData: TStringList;

    procedure SetupData(Value: TStringList);
    procedure LoadSetupData;
    procedure SaveSetupData;
  protected
    FImagePic1: TPicName; // 
    FImagePic2: TPicName; // 

    procedure SetDirPicture(idx, value: integer);
    procedure SetDirBlokFrame(idx, value: integer);

    procedure Loaded; override;
  public
    TagName: TTagName;
    DeviceName: TDeviceName;
    ImagePic: TPicName;

    LabelObj: TLabel;

    DirCount: integer;
    Dir: array of PVisZDVHDir;

    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;

    procedure Init; override;
    procedure Process; override;

    procedure FreeDirs;

  published
    property Data: TStringList read FData write SetupData;
  end;


  TVisZDVHEditor = class(TComponentEditor)
  private
  public
    procedure Edit; override;
  end;



procedure Register;

implementation
uses
  TagStorage,
  numbers,
  ExtDlgs,
  VisZDVHSetup;

procedure Register;
begin
  RegisterComponents('Scada', [TVisZDVH]);
  RegisterComponentEditor(TVisZDVH, TVisZDVHEditor);
end;

{ TVisZDVH }

constructor TVisZDVH.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FEraseBackground := true;
  Width := 100;
  Height := 100;
  ShowHint := true;

  FData := TStringList.Create;

  Dir := nil;
  DirCount := 0;

  //  
  LabelObj := TLabel.Create(Self);
  LabelObj.Parent := self;
  LabelObj.Visible := true;
  LabelObj.Transparent := true;
  LabelObj.Font.Color := clWhite;
  LabelObj.Font.Size := 10;
  LabelObj.Font.Style := [fsBold];
  LabelObj.Font.Name := 'Tahoma';

  LabelObj.OnClick := OnDeviceClick;
end;

destructor TVisZDVH.Destroy;
begin
  FreeDirs;
  inherited;
end;

procedure TVisZDVH.SetupData(Value: TStringList);
begin
  FData.Assign(Value);
  LoadSetupData;
end;


procedure TVisZDVH.SetDirPicture(idx, value: integer);
begin
  if Value <> Dir[idx].valOpened then begin
    if Value=0 then
      Dir[idx].ImageObj.Picture.LoadFromFile(VisImagesPath + FImagePic1)
    else
      Dir[idx].ImageObj.Picture.LoadFromFile(VisImagesPath + FImagePic2);
    Dir[idx].valOpened := value;  
  end;
end;

procedure TVisZDVH.SetDirBlokFrame(idx, value: integer);
begin
  if Value <> Dir[idx].valBlok then begin
    if Value>0 then
      Dir[idx].FrameBlokObj.Pen.Color := clYellow
    else
      Dir[idx].FrameBlokObj.Pen.Color := Color;
    Dir[idx].valBlok := value;
  end;
end;


// INIT
procedure TVisZDVH.Init;
var
  i: integer;
begin
  IsConnectionBad := false;
  for i:=0 to DirCount-1 do begin

    Dir[i].TagIdxOpened := GetTagIndex(TagPath + '.ZDVH_' + TagName + Dir[i].TagPostfix +
        '_Opened');

    Dir[i].TagIdxBlok := GetTagIndex(TagPath + '.ZDVH_' + TagName + Dir[i].TagPostfix +
        '_Blok');
        
    IsConnectionBad := (Dir[i].TagIdxOpened<0) or (Dir[i].TagIdxBlok<0);
  end;
end;

// PROCESS HANDLER
procedure TVisZDVH.Process;
var
  i, value: integer;
begin
  for i:=0 to DirCount-1 do begin
    IsValueBad := false;

    value := GetTagValue(Dir[i].TagIdxOpened);
    SetDirPicture(i, value);
    IsValueBad := IsValueBad or (value < 0);

    value := GetTagValue(Dir[i].TagIdxBlok);
    SetDirBlokFrame(i, value);
    IsValueBad := IsValueBad or (value < 0);
  end;
  inherited;
end;



procedure TVisZDVH.LoadSetupData;
var
  s, s1, s2: string;
  k, i, j, v: integer;
  img_xs, img_ys, frm_xo, frm_yo, frm_xs, frm_ys, lab_xo, lab_yo: integer;
begin

  // TagPath
  if FData.Count>0 then s := FData.Strings[0] else s := '';
  k := pos('.', s);
  TagPath := copy(s, 1, k-1);

  // TagName
  delete(s, 1, k); k := pos(';', s);
  TagName := copy(s, 1, k-1);

  // DeviceName
  delete(s, 1, k);
  DeviceName := trim(s);
  Hint := DeviceName;


  // Image size
  if FData.Count>1 then s := FData.Strings[1] else s := '';
  k := pos(',', s);
  val(copy(s, 1, k-1), v, j);
  img_xs := v;

  delete(s, 1, k); k := pos(',', s);
  val(copy(s, 1, k-1), v, j);
  img_ys := v;

  // BlokFrame offset
  delete(s, 1, k); k := pos(',', s);
  val(copy(s, 1, k-1), v, j);
  frm_xo := v;

  delete(s, 1, k); k := pos(',', s);
  val(copy(s, 1, k-1), v, j);
  frm_yo := v;

  // BlokFrame size
  delete(s, 1, k); k := pos(',', s);
  val(copy(s, 1, k-1), v, j);
  frm_xs := v;

  delete(s, 1, k); k := pos(',', s);
  val(copy(s, 1, k-1), v, j);
  frm_ys := v;

  // Label offset
  delete(s, 1, k); k := pos(',', s);
  val(copy(s, 1, k-1), v, j);
  lab_xo := v;

  delete(s, 1, k); k := pos(',', s);
  val(copy(s, 1, k-1), v, j);
  lab_yo := v;

  // Pic name
  delete(s, 1, k);
  ImagePic := trim(s);

  // Label
  if FData.Count>2 then s := FData.Strings[2] else s := '';
  k := pos(',', s);
  val(copy(s, 1, k-1), v, j);
  LabelObj.Left := v;

  delete(s, 1, k); k := pos(',', s);
  val(copy(s, 1, k-1), v, j);
  LabelObj.Top := v;

  delete(s, 1, k);
  LabelObj.Caption := trim(s);

  //  
  FreeDirs;
  if FData.Count>3 then s := FData.Strings[3] else s := '';
  val(s, v, j);
  DirCount := v;
  SetLength(Dir, DirCount);

  for i:=0 to DirCount-1 do begin
    new( Dir[i] );
    Dir[i].ImageObj := TImage.Create(Self);
    Dir[i].ImageObj.Parent := self;
    Dir[i].ImageObj.Visible := true;
    Dir[i].ImageObj.Stretch := true;
    Dir[i].ImageObj.OnClick := OnDeviceClick;
    Dir[i].ImageObj.Width := img_xs;
    Dir[i].ImageObj.Height := img_ys;

    Dir[i].FrameBlokObj := TShape.Create(Self);
    Dir[i].FrameBlokObj.Parent := self;
    Dir[i].FrameBlokObj.Visible := true;
    Dir[i].FrameBlokObj.Pen.Color := clYellow;
    Dir[i].FrameBlokObj.Brush.Style := bsClear;
    Dir[i].FrameBlokObj.OnMouseUp := OnDeviceMouseUp;
    Dir[i].FrameBlokObj.Width := frm_xs;
    Dir[i].FrameBlokObj.Height := frm_ys;

    Dir[i].LabelObj := TLabel.Create(Self);
    Dir[i].LabelObj.Parent := self;
    Dir[i].LabelObj.Transparent := true;
    Dir[i].LabelObj.Visible := true;
    Dir[i].LabelObj.Font.Name := 'Courier New';
    Dir[i].LabelObj.Font.Size := 7;
    Dir[i].LabelObj.Font.Color := clMenu;
    Dir[i].LabelObj.OnMouseUp := OnDeviceMouseUp;

    if FData.Count>4+i then s := FData.Strings[4+i] else s := '';
    k := pos(',', s);
    val(copy(s, 1, k-1), v, j);
    Dir[i].ImageObj.Left := v;
    Dir[i].FrameBlokObj.Left := frm_xo + v;
    Dir[i].LabelObj.Left := lab_xo + v;

    delete(s, 1, k); k := pos(',', s);
    val(copy(s, 1, k-1), v, j);
    Dir[i].ImageObj.Top := v;
    Dir[i].FrameBlokObj.Top := frm_yo + v;
    Dir[i].LabelObj.Top := lab_yo + v;

    delete(s, 1, k); k := pos(',', s);
    Dir[i].TagPostfix := copy(s, 1, k-1);

    delete(s, 1, k); k := pos(',', s);
    Dir[i].LabelObj.Caption := copy(s, 1, k-1);

    delete(s, 1, k);
    Dir[i].Name := trim(s);

    s := VisImagesPath + ImagePic;
    try
      if FileExists(s) then Dir[i].ImageObj.Picture.LoadFromFile(s);
    except
    end;

    Dir[i].valOpened := -1;
    Dir[i].valBlok := -1;
  end;

  //  
  s2 := ImagePic;
  i := pos('_',s2);
  s1 := copy(s2, 1, i);
  delete(s2, 1, i+1);

  FImagePic1 := s1 + '1' + s2;
  FImagePic2 := s1 + '2' + s2;
end;

procedure TVisZDVH.SaveSetupData;
var
  i: integer;
begin
  FData.Clear;
  FData.Add( TagPath + '.' + TagName + ';' + DeviceName );

  if DirCount=0 then
    FData.Add( format('0,0,0,0,0,0,0,0,%s', [ImagePic]) )
  else
    FData.Add( format('%d,%d,%d,%d,%d,%d,%d,%d,%s', [
        Dir[0].ImageObj.Width,
        Dir[0].ImageObj.Height,
        Dir[0].FrameBlokObj.Left-Dir[0].ImageObj.Left,
        Dir[0].FrameBlokObj.Top-Dir[0].ImageObj.Top,
        Dir[0].FrameBlokObj.Width,
        Dir[0].FrameBlokObj.Height,
        Dir[0].LabelObj.Left-Dir[0].ImageObj.Left,
        Dir[0].LabelObj.Top-Dir[0].ImageObj.Top,
        ImagePic]) );

  FData.Add( format('%d,%d,%s', [LabelObj.Left, LabelObj.Top, LabelObj.Caption]) );

  FData.Add(IntToStr(DirCount));
  for i:=0 to DirCount-1 do
    FData.Add( format('%d,%d,%s,%s,%s', [
        Dir[i].ImageObj.Left, Dir[i].ImageObj.Top,
        Dir[i].TagPostfix,
        Dir[i].LabelObj.Caption,
        Dir[i].Name
        ]));
end;


procedure TVisZDVH.Loaded;
begin
  inherited;
  LoadSetupData;
end;


procedure TVisZDVH.FreeDirs;
var
  i: integer;
begin
  for i:=0 to DirCount-1 do begin
    Dir[i].ImageObj.Free;
    Dir[i].FrameBlokObj.Free;
    Dir[i].LabelObj.Free;
    Dispose(Dir[i]);
  end;
  Dir := nil;
end;



{ TVisZDVHEditor }

procedure TVisZDVHEditor.Edit;
begin
  inherited;
  VisZDVHSetupForm := TVisZDVHSetupForm.Create(nil);

  VisZDVHSetupForm.M := Component as TVisZDVH;
  VisZDVHSetupForm.D := Self;
  if VisZDVHSetupForm.ShowModal = mrOk then
    VisZDVHSetupForm.M.SaveSetupData
  else
    VisZDVHSetupForm.M.LoadSetupData;

  VisZDVHSetupForm.Free;
end;


end.
