// DEPRECATED !!!   .  !

unit VisZDVHSetup;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, VisZDVH, Mask, ExtCtrls, Buttons, ComCtrls, RpVisualGlobal;

type
  TVisZDVHSetupForm = class(TForm)
    Panel1: TPanel;
    DeviceNameEdit: TMaskEdit;
    Label1: TLabel;
    Label2: TLabel;
    LabelEdit: TMaskEdit;
    Label3: TLabel;
    TagNameEdit: TMaskEdit;
    TagPathEdit: TMaskEdit;
    Label4: TLabel;
    Panel2: TPanel;
    PicNameEdit: TMaskEdit;
    Label9: TLabel;
    ImageSXEdit: TEdit;
    ImageSYEdit: TEdit;
    Label10: TLabel;
    Label11: TLabel;
    udImageSY: TUpDown;
    udImageSX: TUpDown;
    Panel3: TPanel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    MainXEdit: TEdit;
    MainYEdit: TEdit;
    udMainY: TUpDown;
    udMainX: TUpDown;
    MainSXEdit: TEdit;
    MainSYEdit: TEdit;
    udMainSY: TUpDown;
    udMainSX: TUpDown;
    Label12: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    Panel4: TPanel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    Label27: TLabel;
    LabelXEdit: TEdit;
    LabelYEdit: TEdit;
    udLabelY: TUpDown;
    udLabelX: TUpDown;
    OkButton: TBitBtn;
    CancelButton: TBitBtn;
    ImagePanel: TPanel;
    ImageView: TImage;
    Timer: TTimer;
    cbImageAnim: TCheckBox;
    btImageReset: TSpeedButton;
    Panel5: TPanel;
    Label5: TLabel;
    DirTagPostfixEdit: TMaskEdit;
    DirNameEdit: TMaskEdit;
    Label24: TLabel;
    Label25: TLabel;
    Label26: TLabel;
    Label28: TLabel;
    Label29: TLabel;
    DirXEdit: TEdit;
    DirYEdit: TEdit;
    udDirY: TUpDown;
    udDirX: TUpDown;
    DirList: TListBox;
    btDirAdd: TSpeedButton;
    btDirDel: TSpeedButton;
    Panel6: TPanel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label35: TLabel;
    Label36: TLabel;
    Label37: TLabel;
    Label38: TLabel;
    FrameXEdit: TEdit;
    FrameYEdit: TEdit;
    udFrameY: TUpDown;
    udFrameX: TUpDown;
    FrameSXEdit: TEdit;
    FrameSYEdit: TEdit;
    udFrameSY: TUpDown;
    udFrameSX: TUpDown;
    Panel7: TPanel;
    Label31: TLabel;
    Label32: TLabel;
    Label33: TLabel;
    Label30: TLabel;
    NumXEdit: TEdit;
    NumYEdit: TEdit;
    udNumY: TUpDown;
    udNumX: TUpDown;
    Label34: TLabel;
    DirLabelEdit: TMaskEdit;
    procedure DeviceNameEditChange(Sender: TObject);
    procedure LabelEditChange(Sender: TObject);
    procedure TagPathEditChange(Sender: TObject);
    procedure TagNameEditChange(Sender: TObject);
    procedure MainYEditChange(Sender: TObject);
    procedure MainSXEditChange(Sender: TObject);
    procedure MainSYEditChange(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure LabelXEditChange(Sender: TObject);
    procedure LabelYEditChange(Sender: TObject);
    procedure ImageSXEditChange(Sender: TObject);
    procedure ImageSYEditChange(Sender: TObject);
    procedure btOpenPicClick(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure btImageResetClick(Sender: TObject);
    procedure MainXEditChange(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure DirListClick(Sender: TObject);
    procedure DirNameEditChange(Sender: TObject);
    procedure DirXEditChange(Sender: TObject);
    procedure DirYEditChange(Sender: TObject);
    procedure btDirAddClick(Sender: TObject);
    procedure btDirDelClick(Sender: TObject);
    procedure FrameXEditChange(Sender: TObject);
    procedure FrameYEditChange(Sender: TObject);
    procedure FrameSXEditChange(Sender: TObject);
    procedure FrameSYEditChange(Sender: TObject);
    procedure DirTagPostfixEditChange(Sender: TObject);
    procedure NumXEditChange(Sender: TObject);
    procedure NumYEditChange(Sender: TObject);
    procedure DirLabelEditChange(Sender: TObject);
  private
    NotLoaded: boolean;
    ImageAnimNum: integer;
    procedure Modify;
    procedure SetImageSize;
  public
    M: TVisZDVH;
    D: TVisZDVHEditor;
    
  end;

var
  VisZDVHSetupForm: TVisZDVHSetupForm;

implementation
uses ExtDlgs, inifiles;

{$R *.DFM}

procedure TVisZDVHSetupForm.FormActivate(Sender: TObject);
var
  s: string;
  i: integer;
begin
  DeviceNameEdit.Text := M.DeviceName;
  TagPathEdit.Text := M.TagPath;
  TagNameEdit.Text := M.TagName;
  LabelEdit.Text := M.LabelObj.Caption;

  udMainX.Position := M.Left;
  udMainY.Position := M.Top;
  udMainSX.Position := M.Width;
  udMainSY.Position := M.Height;

  udLabelX.Position := M.LabelObj.Left;
  udLabelY.Position := M.LabelObj.Top;

  if M.DirCount>0 then with M.Dir[0]^ do begin
    udFrameX.Position := FrameBlokObj.Left - ImageObj.Left;
    udFrameY.Position := FrameBlokObj.Top - ImageObj.Top;
    udFrameSX.Position := FrameBlokObj.Width;
    udFrameSY.Position := FrameBlokObj.Height;
    udNumX.Position := LabelObj.Left - ImageObj.Left;
    udNumY.Position := LabelObj.Top - ImageObj.Top;
  end else begin
    udFrameX.Position := 0;
    udFrameY.Position := 0;
    udFrameSX.Position := 0;
    udFrameSY.Position := 0;
    udNumX.Position := 0;
    udNumY.Position := 0;
  end;


  PicNameEdit.Text := M.ImagePic;
  if M.DirCount > 0 then begin
    udImageSX.Position := M.Dir[0].ImageObj.Width;
    udImageSY.Position := M.Dir[0].ImageObj.Height;
  end else begin
    udImageSX.Position := 0;
    udImageSY.Position := 0;
  end;

  s := VisImagesPath + M.ImagePic;
  try
    if FileExists(s) then ImageView.Picture.LoadFromFile(s);
    SetImageSize;
    ImagePanel.Color := clBtnFace;
  except
    ImagePanel.Color := clRed;
  end;

  //  
  for i:=0 to M.DirCount-1 do begin
    DirList.Items.Add(M.Dir[i].Name);
  end;
  if M.DirCount>0 then DirList.ItemIndex := 0;
  DirListClick(nil);

  NotLoaded := false;
end;


procedure TVisZDVHSetupForm.DirListClick(Sender: TObject);
begin
  if DirList.ItemIndex < 0 then begin
    DirList.Clear;
    DirNameEdit.Text := '';
    DirLabelEdit.Text := '';
    udDirX.Position := 0;
    udDirY.Position := 0;
    DirTagPostfixEdit.Text := '';
  end else
    if DirList.ItemIndex < M.DirCount then begin
      DirNameEdit.Text := M.Dir[DirList.ItemIndex].Name;
      DirLabelEdit.Text := M.Dir[DirList.ItemIndex].LabelObj.Caption;
      udDirX.Position := M.Dir[DirList.ItemIndex].ImageObj.Left;
      udDirY.Position := M.Dir[DirList.ItemIndex].ImageObj.Top;
      DirTagPostfixEdit.Text := M.Dir[DirList.ItemIndex].TagPostfix;
    end;
end;


procedure TVisZDVHSetupForm.FormCreate(Sender: TObject);
begin
  NotLoaded := true;
  with TIniFile.Create(GetCurrentDir + '\VisScada.ini') do begin
    Left := ReadInteger('VisZDVH', 'Left', 6);
    Top := ReadInteger('VisZDVH', 'Top', 4);
    cbImageAnim.Checked := ReadBool('VisZDVH', 'ImageAnim', false);
    Free;
  end;
end;

procedure TVisZDVHSetupForm.FormDestroy(Sender: TObject);
begin
  with TIniFile.Create(GetCurrentDir + '\VisScada.ini') do begin
    WriteInteger('VisZDVH', 'Left', Left);
    WriteInteger('VisZDVH', 'Top', Top);
    WriteBool('VisZDVH', 'ImageAnim', cbImageAnim.Checked);
    Free;
  end;
end;


procedure TVisZDVHSetupForm.Modify;
begin
  M.Left := M.Left + 1;
  M.Left := M.Left - 1;
  D.Designer.Modified;
end;

procedure TVisZDVHSetupForm.DeviceNameEditChange(Sender: TObject);
begin
  if NotLoaded then exit;
  M.DeviceName := DeviceNameEdit.Text;
  D.Designer.Modified;
end;

procedure TVisZDVHSetupForm.LabelEditChange(Sender: TObject);
begin
  if NotLoaded then exit;
  M.LabelObj.Caption := LabelEdit.Text;
  Modify;
end;

procedure TVisZDVHSetupForm.TagPathEditChange(Sender: TObject);
begin
  if NotLoaded then exit;
  M.TagPath := TagPathEdit.Text;
  D.Designer.Modified;
end;

procedure TVisZDVHSetupForm.TagNameEditChange(Sender: TObject);
begin
  if NotLoaded then exit;
  M.TagName := TagNameEdit.Text;
  D.Designer.Modified;
end;

procedure TVisZDVHSetupForm.MainXEditChange(Sender: TObject);
begin
  if (NotLoaded) or (MainXEdit.Text='') then exit;
  M.Left := StrToInt(MainXEdit.Text);
  D.Designer.Modified;
end;

procedure TVisZDVHSetupForm.MainYEditChange(Sender: TObject);
begin
  if (NotLoaded) or (MainYEdit.Text='') then exit;
  M.Top := StrToInt(MainYEdit.Text);
  D.Designer.Modified;
end;

procedure TVisZDVHSetupForm.MainSXEditChange(Sender: TObject);
begin
  if (NotLoaded) or (MainSXEdit.Text='') then exit;
  M.Width := StrToInt(MainSXEdit.Text);
  D.Designer.Modified;
end;

procedure TVisZDVHSetupForm.MainSYEditChange(Sender: TObject);
begin
  if (NotLoaded) or (MainSYEdit.Text='') then exit;
  M.Height := StrToInt(MainSYEdit.Text);
  D.Designer.Modified;
end;


procedure TVisZDVHSetupForm.LabelXEditChange(Sender: TObject);
begin
  if (NotLoaded) or (LabelXEdit.Text='') then exit;
  M.LabelObj.Left := StrToInt(LabelXEdit.Text);
  Modify;
end;

procedure TVisZDVHSetupForm.LabelYEditChange(Sender: TObject);
begin
  if (NotLoaded) or (LabelXEdit.Text='') then exit;
  M.LabelObj.Top := StrToInt(LabelYEdit.Text);
  Modify;
end;

procedure TVisZDVHSetupForm.ImageSXEditChange(Sender: TObject);
var
  i: integer;
begin
  if (NotLoaded) or (ImageSXEdit.Text='') then exit;
  for i:=0 to M.DirCount-1 do
    M.Dir[i].ImageObj.Width := StrToInt(ImageSXEdit.Text);
  Modify;
end;

procedure TVisZDVHSetupForm.ImageSYEditChange(Sender: TObject);
var
  i: integer;
begin
  if (NotLoaded) or (ImageSYEdit.Text='') then exit;
  for i:=0 to M.DirCount-1 do
    M.Dir[i].ImageObj.Height := StrToInt(ImageSYEdit.Text);
  Modify;
end;


// Blok Frames
procedure TVisZDVHSetupForm.FrameXEditChange(Sender: TObject);
var
  i: integer;
begin
  if (NotLoaded) or (FrameXEdit.Text='') then exit;
  for i:=0 to M.DirCount-1 do
    M.Dir[i].FrameBlokObj.Left := M.Dir[i].ImageObj.Left + StrToInt(FrameXEdit.Text);
  Modify;
end;

procedure TVisZDVHSetupForm.FrameYEditChange(Sender: TObject);
var
  i: integer;
begin
  if (NotLoaded) or (FrameYEdit.Text='') then exit;
  for i:=0 to M.DirCount-1 do
    M.Dir[i].FrameBlokObj.Top := M.Dir[i].ImageObj.Top + StrToInt(FrameYEdit.Text);
  Modify;
end;

procedure TVisZDVHSetupForm.FrameSXEditChange(Sender: TObject);
var
  i: integer;
begin
  if (NotLoaded) or (FrameSXEdit.Text='') then exit;
  for i:=0 to M.DirCount-1 do
    M.Dir[i].FrameBlokObj.Width := StrToInt(FrameSXEdit.Text);
  Modify;
end;

procedure TVisZDVHSetupForm.FrameSYEditChange(Sender: TObject);
var
  i: integer;
begin
  if (NotLoaded) or (FrameSYEdit.Text='') then exit;
  for i:=0 to M.DirCount-1 do
    M.Dir[i].FrameBlokObj.Height := StrToInt(FrameSYEdit.Text);
  Modify;
end;


// Dir label position
procedure TVisZDVHSetupForm.NumXEditChange(Sender: TObject);
var
  i: integer;
begin
  if (NotLoaded) or (NumXEdit.Text='') then exit;
  for i:=0 to M.DirCount-1 do
    M.Dir[i].LabelObj.Left := M.Dir[i].ImageObj.Left + StrToInt(NumXEdit.Text);
  Modify;
end;

procedure TVisZDVHSetupForm.NumYEditChange(Sender: TObject);
var
  i: integer;
begin
  if (NotLoaded) or (NumYEdit.Text='') then exit;
  for i:=0 to M.DirCount-1 do
    M.Dir[i].LabelObj.Top := M.Dir[i].ImageObj.Top + StrToInt(NumYEdit.Text);
  Modify;
end;



procedure TVisZDVHSetupForm.btOpenPicClick(Sender: TObject);
var
  i: integer;
  Dlg: TOpenPictureDialog;
begin
  Dlg := TOpenPictureDialog.Create(nil);
  Dlg.InitialDir := VisImagesPath + M.ImagePic;
  Dlg.Options := Dlg.Options + [ofNoChangeDir];
  if Dlg.Execute then begin
    PicNameEdit.Text := ExtractFileName( Dlg.FileName );

    M.ImagePic := PicNameEdit.Text;

    ImageView.Picture.LoadFromFile(Dlg.FileName);

    for i:=0 to M.DirCount-1 do
      M.Dir[i].ImageObj.Picture.LoadFromFile(Dlg.FileName);

    ImagePanel.Color := clBtnFace;

    udImageSX.Position := ImageView.Picture.Width;
    udImageSY.Position := ImageView.Picture.Height;
    SetImageSize;

    Modify;
  end;
  Dlg.Free;
end;

procedure TVisZDVHSetupForm.SetImageSize;
var
  x,y,sx,sy,ix,iy: integer;
begin

  if M.DirCount>0 then begin
    ix := ImagePanel.Width-1;
    iy := ImagePanel.Height-1;
    sx := M.Dir[0].ImageObj.Picture.Width;
    sy := M.Dir[0].ImageObj.Picture.Height;

    if sx>ix then begin
      sy := sy*ix div sx;
      sx := ix;
    end;

    if sy>iy then begin
      sx := sx*iy div sy;
      sy := iy;
    end;

    x := (ix-sx) div 2;
    y := (iy-sy) div 2;
  end else begin
    x := 0;
    y := 0;
    sx := 0;
    sy := 0;
  end;

  ImageView.Left := x;
  ImageView.Top := y;
  ImageView.Width := sx;
  ImageView.Height := sy;

end;

procedure TVisZDVHSetupForm.TimerTimer(Sender: TObject);
var
  s: string;
  k,n: integer;
begin
  if (cbImageAnim.Checked) and (M.DirCount>0) and (DirList.ItemIndex>=0) then begin
    n := DirList.ItemIndex;
    s := trim(M.ImagePic);
    if length(s) > 0 then begin
      inc(ImageAnimNum);
      if (ImageAnimNum > 2) or (ImageAnimNum < 1) then ImageAnimNum := 1;
      try
        k := pos('_',s);
        if k=0 then raise Exception.Create('');
        delete(s, k, 2);
        insert(format('_%d',[ImageAnimNum]), s, k);
        s := VisImagesPath + s;

        ImageView.Picture.LoadFromFile(s);
        M.Dir[n].ImageObj.Picture.LoadFromFile(s);
        ImagePanel.Color := clBtnFace;

      except
        ImagePanel.Color := clRed;
      end;
    end;
  end;
end;

procedure TVisZDVHSetupForm.btImageResetClick(Sender: TObject);
begin
  if M.DirCount>0 then begin
    udImageSX.Position := M.Dir[0].ImageObj.Picture.Width;
    udImageSY.Position := M.Dir[0].ImageObj.Picture.Height;
  end;
end;




procedure TVisZDVHSetupForm.DirNameEditChange(Sender: TObject);
begin
  if NotLoaded then exit;
  if (DirList.ItemIndex >= 0) and (DirList.ItemIndex < M.DirCount) then begin
    M.Dir[DirList.ItemIndex].Name := DirNameEdit.Text;
    DirList.Items.Strings[DirList.ItemIndex] := DirNameEdit.Text;
    D.Designer.Modified;
  end;
end;

procedure TVisZDVHSetupForm.DirLabelEditChange(Sender: TObject);
begin
  if NotLoaded then exit;
  if (DirList.ItemIndex >= 0) and (DirList.ItemIndex < M.DirCount) then begin
    M.Dir[DirList.ItemIndex].LabelObj.Caption := DirLabelEdit.Text;
    D.Designer.Modified;
  end;
end;

procedure TVisZDVHSetupForm.DirTagPostfixEditChange(Sender: TObject);
begin
  if NotLoaded then exit;
  if (DirList.ItemIndex >= 0) and (DirList.ItemIndex < M.DirCount) then begin
    M.Dir[DirList.ItemIndex].TagPostfix := DirTagPostfixEdit.Text;
    D.Designer.Modified;
  end;
end;

procedure TVisZDVHSetupForm.DirXEditChange(Sender: TObject);
begin
  if (NotLoaded) or (DirXEdit.Text='') then exit;
  if (DirList.ItemIndex >= 0) and (DirList.ItemIndex < M.DirCount) then begin
    M.Dir[DirList.ItemIndex].ImageObj.Left := StrToInt(DirXEdit.Text);
    M.Dir[DirList.ItemIndex].FrameBlokObj.Left :=
        StrToInt(DirXEdit.Text) + StrToInt(FrameXEdit.Text);
    M.Dir[DirList.ItemIndex].LabelObj.Left :=
        StrToInt(DirXEdit.Text) + StrToInt(NumXEdit.Text);
    Modify;
  end;
end;

procedure TVisZDVHSetupForm.DirYEditChange(Sender: TObject);
begin
  if (NotLoaded) or (DirYEdit.Text='') then exit;
  if (DirList.ItemIndex >= 0) and (DirList.ItemIndex < M.DirCount) then begin
    M.Dir[DirList.ItemIndex].ImageObj.Top := StrToInt(DirYEdit.Text);
    M.Dir[DirList.ItemIndex].FrameBlokObj.Top :=
      StrToInt(DirYEdit.Text) + StrToInt(FrameYEdit.Text);
    M.Dir[DirList.ItemIndex].LabelObj.Top :=
      StrToInt(DirYEdit.Text) + StrToInt(NumYEdit.Text);
    Modify;
  end;
end;

procedure TVisZDVHSetupForm.btDirAddClick(Sender: TObject);
var
  k: integer;
  s: string;
begin
  k := M.DirCount;
  M.DirCount := M.DirCount + 1;
  SetLength(M.Dir, M.DirCount);

  new(M.Dir[k]);


  M.Dir[k].ImageObj := TImage.Create(M);
  M.Dir[k].ImageObj.Parent := M;
  M.Dir[k].ImageObj.Visible := true;
  M.Dir[k].ImageObj.Stretch := true;
  M.Dir[k].ImageObj.Left := 0;
  M.Dir[k].ImageObj.Top := 0;
  M.Dir[k].ImageObj.Width := StrToInt(ImageSXEdit.Text);
  M.Dir[k].ImageObj.Height := StrToInt(ImageSYEdit.Text);

  s := VisImagesPath + M.ImagePic;
  try
    if FileExists(s) then M.Dir[k].ImageObj.Picture.LoadFromFile(s);
  except
  end;


  M.Dir[k].FrameBlokObj := TShape.Create(M);
  M.Dir[k].FrameBlokObj.Parent := M;
  M.Dir[k].FrameBlokObj.Visible := true;
  M.Dir[k].FrameBlokObj.Pen.Color := clYellow;
  M.Dir[k].FrameBlokObj.Brush.Style := bsClear;
  M.Dir[k].FrameBlokObj.Left := StrToInt(FrameXEdit.Text) + M.Dir[k].ImageObj.Width;
  M.Dir[k].FrameBlokObj.Top := StrToInt(FrameYEdit.Text) + M.Dir[k].ImageObj.Height;
  M.Dir[k].FrameBlokObj.Width := StrToInt(FrameSXEdit.Text);
  M.Dir[k].FrameBlokObj.Height := StrToInt(FrameSYEdit.Text);

  M.Dir[k].LabelObj := TLabel.Create(M);
  M.Dir[k].LabelObj.Parent := M;
  M.Dir[k].LabelObj.Visible := true;
  M.Dir[k].LabelObj.Font.Name := 'Courier New';
  M.Dir[k].LabelObj.Font.Size := 7;
  M.Dir[k].LabelObj.Font.Color := clMenu;
  M.Dir[k].LabelObj.Left := StrToInt(NumXEdit.Text) + M.Dir[k].ImageObj.Width;
  M.Dir[k].LabelObj.Top := StrToInt(NumYEdit.Text) + M.Dir[k].ImageObj.Height;

  M.Dir[k].Name := '';
  M.Dir[k].TagPostfix := '';

  DirList.Items.Add('');
  DirList.ItemIndex := DirList.Items.Count-1;
  DirListClick(nil);
  D.Designer.Modified;
end;

procedure TVisZDVHSetupForm.btDirDelClick(Sender: TObject);
var
  i,k: integer;
begin
  k := DirList.ItemIndex;
  if (k>=0) and (k<M.DirCount) then begin
    M.Dir[k].ImageObj.Free;
    M.Dir[k].FrameBlokObj.Free;
    M.Dir[k].LabelObj.Free;
    dispose(M.Dir[k]);

    for i:=k to M.DirCount-2 do M.Dir[i] := M.Dir[i+1];
    M.DirCount := M.DirCount-1;
    SetLength(M.Dir, M.DirCount);

    DirList.Items.Delete(k);
    if k = DirList.Items.Count then Dec(k);
    DirList.ItemIndex := k;
    DirListClick(nil);
    D.Designer.Modified;
  end;
end;



end.
