unit VisZcta;



interface

uses
  DesignIntf, DesignEditors,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, stdctrls, ScadaBase, uPSComponent, uPSCompiler, uPSRuntime;


type
  PVisZctaItemRec =^TVisZctaItemRec;
  TVisZctaItemRec = record
    DeviceName: string;
    DirName: string;
    DirNum: integer;
    OutputTagName: string;
    OutputTagIndex: integer;
  end;

  TVisZcta = class(TCustomScadaObject)
  private
  protected
    FTagname: string;

    FFilterAdd: string;
    FFilterDel: string;

    FLabel: TLabel;
    FPanel: TPanel;
    FBevel: TBevel;
    FButton: TButton;

    FDBNameParam: string;

    FTagSost: integer;
    FTagCode: integer;

    FFirstPass: boolean;
    FSecondPass: boolean;

  public
    DBName: string;
    Code: integer;
    Sost: integer;
    DatabaseConnectOk: boolean;
    ZdvItems: array of PVisZctaItemRec;
    ZdvItemsCount: integer;

    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Init; override;
    procedure Process; override;
    procedure ButtonClick(sender: TObject);
    procedure PanelClick(sender: TObject);
    procedure ZdvItemsClear;
    procedure ZdvItemsInit(size: integer);

  published
    property objLabel: TLabel read FLabel;                          
    property objPanel: TPanel read FPanel;
    property objBevel: TBevel read FBevel;
    property objButton: TButton read FButton;

    property Tagname: string read FTagname write FTagname;

    property DBNameParam: string read FDBNameParam write FDBNameParam;

    property FilterAdd: string read FFilterAdd write FFilterAdd;
    property FilterDel: string read FFilterDel write FFilterDel;

    property Align;
    property Anchors;
    property Enabled;
    property Visible;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
  end;

{
  TVisZctaEditor = class(TComponentEditor)
  private
  public
    procedure Edit; override;
  end;
}


procedure Register;

implementation
uses
  RpVisualParams,
  VisZctaConfig,
  VisZctaStatus,
  TagStorage,
  numbers,
  hyperstr, DB,
    RpVisualGlobal,
  RpVisualLegacyPanels,
  RpVisualUtils,
  RpVisualMain;



procedure Register;
begin
  RegisterComponents('Scada', [TVisZcta]);
//  RegisterComponentEditor(TVisZcta, TVisZctaEditor);
end;

{ TVisualDevice }


constructor TVisZcta.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  ShowHint := true;

  Width := 437;
  Height := 68;

  //  shape
  FBevel := TBevel.Create(Self);
  FBevel.Name := 'objBevel';
  FBevel.Parent := self;
  FBevel.Visible := true;
  FBevel.SetSubComponent(true);
  FBevel.Align := alClient;
  FBevel.Shape := bsFrame;

  //  
  FLabel := TLabel.Create(Self);
  FLabel.Name := 'objLabel';
  FLabel.Parent := self;
  FLabel.Visible := true;
  FLabel.SetSubComponent(true);
  FLabel.Font.Name := 'Tahoma';
  FLabel.Font.Size := 10;
  FLabel.Font.Style := [fsBold];
  FLabel.Left := 12;
  FLabel.Top := 8;
  FLabel.ShowHint := true;
  FLabel.Caption := ' ';

  //  
  FPanel := TPanel.Create(Self);
  FPanel.Name := 'objPanel';
  FPanel.Caption := '';
  FPanel.Parent := self;
  FPanel.Visible := true;
  FPanel.SetSubComponent(true);
  FPanel.Anchors := [akLeft, akTop, akRight];
  FPanel.BevelOuter := bvLowered;
  FPanel.Font.Style := [fsBold];
  FPanel.Height := 25;
  FPanel.Left := 11;
  FPanel.Top := 31;
  FPanel.Width := 414;
  FPanel.OnClick := PanelClick;

  FButton := TButton.Create(Self);
  FButton.Name := 'objButton';
  FButton.Parent := self;
  FButton.Visible := true;
  FButton.SetSubComponent(true);
  FButton.Caption := '';
  FButton.Font.Name := 'Tahoma';
  FButton.Font.Size := 7;
  FButton.Left := 364;
  FButton.Top := 8;
  FButton.Width := 61;
  FButton.Height := 19;
  FButton.Anchors := [akTop, akRight];
  FButton.OnClick := ButtonClick;
  FButton.Enabled := false;

  FDBNameParam := '';
end;


destructor TVisZcta.Destroy;
begin
  ZdvItemsClear;
  inherited;
end;


// INIT
procedure TVisZcta.Init;
var
  _tagname: string;
begin
  inherited;

  _tagname := repl(FTagname, TagIdRoot, TagRoot);

  FTagSost := GetTagIndex(TagPath + '.ZCTA_' + _TagName + '_Sost');
  FTagCode := GetTagIndex(TagPath + '.ZCTA_' + _TagName + '_Code');

  DBNameParam := trim(DBNameParam);
  if DBNameParam='' then
    DBName := ''
  else
    DBName := rpVisualParams_Read( DBNameParam, '  RoboPlant ', '');

  FFirstPass := true;
  FSecondPass := true;

  Code := 0;
  Sost := -1;
end;

// PROCESS HANDLER
procedure TVisZcta.Process;
var
  i: integer;
begin

  if FFirstPass then begin
    //      

    DatabaseConnectOk := VisZctaConfigFormCreate(self, DBName);

    if DatabaseConnectOk then begin
      objPanel.Caption := '';

      //  
//      LoadDevicesFromDatabase;

    end else
      objPanel.Caption := '   "' + DBName + '"';

    FFirstPass := false;
  end else

  if FSecondPass then begin
    //   
    VisZctaConfigFormFree;
    FSecondPass := false;
    FButton.Enabled := true;
  end;


  if (not FFirstPass) and (not FSecondPass) then begin

    // root name
    i := GetTagValue(FTagCode);
    if Code <> i then begin
      Code := i;
      VisZctaLoadRootName(self, Code);
    end;

    // sost + current
    i := GetTagValue(FTagSost);
    if (Sost<>i) then begin
      Sost := i;
      case Sost of
        0: objPanel.Caption := '';
        1: objPanel.Caption := '';
        2: objPanel.Caption := ' ...';
        3: objPanel.Caption := '  ...';
        4: objPanel.Caption := '  ';
      else
        objPanel.Caption := '';
      end;

      case Sost of
        4: objPanel.Color := clRed;
        1..3: objPanel.Color := clLime;
      else
        objPanel.Color := clBtnFace
      end;

      if (Code=0) or (Code=65535) then begin
        objPanel.Caption := '';
      end else begin
        objLabel.Font.Color := clBtnText;
      end;


    end;
  end;


end;




procedure TVisZcta.ButtonClick(sender: TObject);
begin
  if not rvgLogIn then exit;

  if VisZctaConfigFormCreate(self, DBName) then begin
    VisZctaOpenDevices(FilterAdd, FilterDel);
    VisZctaOpenDatasets;
    VisZctaConfigForm.dsCurM.Locate('CODE', Code, []);
//    VisZctaConfigForm.FormStyle := fsStayOnTop;
    if Sost>0 then begin
      VisZctaConfigForm.Visible := false;
      VisZctaConfigForm.acCurSet.Enabled := false;
      VisZctaConfigForm.acReset.Enabled := false;
    end;
    VisZctaConfigForm.Show;

    if (Code>0) and (Code<65535) then
      VisZctaConfigForm.acCheckExecute(nil);

  end;
end;

procedure TVisZcta.PanelClick(sender: TObject);
begin

  if not rvgLogIn then exit;

  VisZctaStatusForm := TVisZctaStatusForm.Create(nil);
  VisZctaStatusForm.M := self;
  VisZctaStatusForm.ShowModal;
  VisZctaStatusForm.Free;

end;



{ TVisZctaEditor }
{
procedure TVisZctaEditor.Edit;
begin
  inherited;
  VisZctaSetupForm := TVisZctaSetupForm.Create(nil);
  VisZctaSetupForm.M := Component as TVisZcta;
  VisZctaSetupForm.D := Self;
  VisZctaSetupForm.ShowModal;
  VisZctaSetupForm.Free;
end;
}


procedure TVisZcta.ZdvItemsClear;
var
  i: integer;
begin
  for i:=0 to ZdvItemsCount-1 do
    dispose(ZdvItems[i]);
  ZdvItems := nil;
  ZdvItemsCount:=0;  
end;

procedure TVisZcta.ZdvItemsInit(size: integer);
begin
  ZdvItemsClear;
  ZdvItemsCount := size;
  SetLength(ZdvItems, ZdvItemsCount);
end;

initialization

finalization

end.
