unit VisZctaCheck;


interface
uses
  sysutils,
  classes,
  dialogs,
  VisZctaConfig;

  procedure Check_ZCTA_DEVDIRS(wnd: TVisZctaConfigForm);

implementation

uses Forms;

procedure Check_ZCTA_DEVDIRS(wnd: TVisZctaConfigForm);
var
  s, devtype, dirname, devname: string;
  dirs: array[0..255] of string[64];
  dircount: integer;
  l: TStringList;
  i,n,k, dirnum: integer;
begin
  l := TStringList.Create;
  with wnd do
  try

    ds2.Open;
    ds2_DevDirs.Open;
    dirs[0] := ' ';
    while not ds2.Eof do begin
      dircount := 1;
      l.text := ds2DATA.AsString;
      devtype := ds2DEVTYPE.AsString;
      devname := ds2NAME.AsString;

      n := l.Count;
      for i:=0 to n-1 do begin
        s := l[i];
        if copy(s,1,13)<>'//CMDLIST:DIR' then continue;
        dirname := copy(s, pos('=',s)+1, 64);
        dirnum := dircount;
        dirs[dirnum] := dirname;
        inc(dircount);
      end;

      if dircount=1 then begin
        if devtype='ZDVA' then begin
          if pos('', devname)>0 then begin
            dirs[1]:=' 1';
            dirs[2]:=' 2';
          end else begin
            dirs[1]:='';
            dirs[2]:='';
          end;
          dircount:=3;
        end;

        if devtype='ZDVT' then begin
          for i:=0 to n-1 do
            if copy(l[i],1,3)='en#' then begin
              s := copy(l[i],4,3);
              val(s, dircount, k);
              inc(dircount);
              if dircount<1 then dircount:=1;
              break;
            end;

          for i:=1 to dircount-1 do
            dirs[i]:=' ' + inttostr(i);
        end;
      end;

      
      for i:=0 to dircount-1 do begin
        dirname := dirs[i];
        dirnum := i;

        if ds2_DevDirs.Locate('DIRNAME', dirname, []) then begin
          if ds2_DevDirsDIRNUM.AsInteger <> dirnum then begin
            ds2_DevDirs.Edit;
            ds2_DevDirsDIRNUM.AsInteger := dirnum;
            ds2_DevDirs.Post;
          end;
        end else begin
          ds2_DevDirs.Append;
          ds2_DevDirsDIRNAME.AsString := dirname;
          ds2_DevDirsDIRNUM.AsInteger := dirnum;
          ds2_DevDirs.Post;
        end;
      end;


      ds2_DevDirs.Last;
      while not ds2_DevDirs.bof do begin
        if ds2_DevDirsDIRNUM.AsInteger < dircount then break;
        ds2_DevDirs.Delete;
//        ds2_DevDirs.Prior;
      end;


      ds2.Next;
    end;
    ds2_DevDirs.Close;
    ds2.Close;
  
  finally
    l.free;
  end;
end;

end.
