unit VisZctaStatus;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs,
  VisZcta, StdCtrls, ComCtrls, ExtCtrls;

type
  TVisZctaStatusForm = class(TForm)
    list: TListView;
    Button2: TButton;
    Timer1: TTimer;
    procedure FormActivate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure listAdvancedCustomDrawSubItem(Sender: TCustomListView;
      Item: TListItem; SubItem: Integer; State: TCustomDrawState;
      Stage: TCustomDrawStage; var DefaultDraw: Boolean);
  private
    { Private declarations }
  public
    M: TVisZcta;
  end;

var
  VisZctaStatusForm: TVisZctaStatusForm;

implementation
uses
  tagstorage;

{$R *.dfm}

procedure TVisZctaStatusForm.FormActivate(Sender: TObject);
var
  i: integer;
begin
  Caption := M.objLabel.Caption;
  for i:=0 to M.ZdvItemsCount-1 do
    with list.Items.Add do begin
      Caption := M.ZdvItems[i].DeviceName;
      SubItems.Add( M.ZdvItems[i].DirName );
      SubItems.Add( M.ZdvItems[i].OutputTagName );
      SubItems.Add( inttostr( M.ZdvItems[i].DirNum ) );
//      data := pointer( M.ZdvItems[i].OutputTagIndex );
    end;
  Timer1Timer(nil);  
end;

procedure TVisZctaStatusForm.Timer1Timer(Sender: TObject);
var
  s: string;
  i: integer;
begin
  for i:=0 to M.ZdvItemsCount-1 do begin
//    s := GetTagName(M.ZdvItems[i].OutputTagIndex);
//    s := inttostr(gettagvalue(M.ZdvItems[i].OutputTagIndex));
//    list.Items[i].SubItems[2] := s;

    if gettagvalue(M.ZdvItems[i].OutputTagIndex)>0 then
      s := ''
    else
      s := '';

    if list.Items[i].SubItems[1] <> s then
      list.Items[i].SubItems[1] := s;
  end;

end;

procedure TVisZctaStatusForm.listAdvancedCustomDrawSubItem(
  Sender: TCustomListView; Item: TListItem; SubItem: Integer;
  State: TCustomDrawState; Stage: TCustomDrawStage;
  var DefaultDraw: Boolean);
begin

  if Item.SubItems[2]='0' then begin
    list.Canvas.Brush.Color := clWhite;
    list.Canvas.Font.Color := clBlack;
  end else

  if Item.SubItems[1]='' then begin
    list.Canvas.Brush.Color := $00A4FFA4;
    list.Canvas.Font.Color := clBlack;
  end else

  begin
    list.Canvas.Brush.Color := clRed;
    list.Canvas.Font.Color := clWhite;
  end;

//  list.Canvas.Brush.Color := $00A4FFA4;
end;

end.
