unit InfoDlg;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, BaseGrid, StdCtrls, ExtCtrls, AdvGlowButton;

type
  TInfoDlgForm = class(TForm)
    lb: TLabel;
    lbHelper: TLabel;
    bt1: TAdvGlowButton;
    bt2: TAdvGlowButton;
    bt3: TAdvGlowButton;
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure updateSize;
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure btClick(Sender: TObject);
  public
    btResult: TAdvGlowButton;
  end;


function showInfoDlg(AMessage: string; ACaption: string = '';
      But1: string = ''; But2: string = ''; But3: string = '';
      BackColor: TColor = clBtnFace; FontColor: TColor = clBlack): integer; overload;

function showInfoDlg(const Msg: string; DlgType: TMsgDlgType;
  Buttons: TMsgDlgButtons; HelpCtx: Longint): Integer; overload;


implementation
uses
  main;

{$R *.dfm}

function showInfoDlg(AMessage: string; ACaption: string;
      But1: string; But2: string; But3: string; BackColor: TColor; FontColor: TColor): integer;
var
  w: TInfoDlgForm;
begin
  w := TInfoDlgForm.Create(Form1);
  w.Caption := ACaption;
  w.lb.Caption := AMessage;
  w.bt1.Caption := But1;
  w.bt2.Caption := But2;
  w.bt3.Caption := But3;
  w.Color := BackColor;
  w.lb.Font.Color := FontColor;
  w.updateSize;
  result := w.ShowModal;

  if (w.bt3.Visible) and (w.btResult = nil) then
    result := 3;

  w.Free

//  MessageDlg('', mtWarning, mbYesNoCancel, 0);
end;


function showInfoDlg(const Msg: string; DlgType: TMsgDlgType;
  Buttons: TMsgDlgButtons; HelpCtx: Longint): Integer;
var
  w: TInfoDlgForm;
  dlgbt: TMsgDlgBtn;
  bt: TAdvGlowButton;
  i: Integer;

begin
  w := TInfoDlgForm.Create(Form1);

  case DlgType of
    mtWarning:
      w.caption := '';
    mtError:
      w.caption := '';
    mtInformation:
      w.caption := '';
    mtConfirmation:
      w.caption := '';
    mtCustom:
      w.caption := '';
  end;

  w.lb.Caption := Msg;
  w.bt1.Caption := '';
  w.bt2.Caption := '';
  w.bt3.Caption := '';

  i := 1;
  for dlgbt := Low(TMsgDlgBtn) to High(TMsgDlgBtn) do
    if dlgbt in Buttons then begin
      case i of
        1: bt := w.bt1;
        2: bt := w.bt2;
        3: bt := w.bt3;
      else
        bt := nil;
      end;

      case dlgbt of
        mbYes:
          begin
            bt.Caption := '';
            bt.ModalResult := mrYes;
          end;
        mbNo:
          begin
            bt.Caption := '';
            bt.ModalResult := mrNo;
          end;
        mbOK:
          begin
            bt.Caption := 'OK';
            bt.ModalResult := mrOk;
          end;
        mbCancel:
          begin
            bt.Caption := '';
            bt.ModalResult := mrCancel;
          end;
        mbAbort:
          begin
            bt.Caption := '';
            bt.ModalResult := mrAbort;
          end;
        mbRetry:
          begin
            bt.Caption := '';
            bt.ModalResult := mrRetry;
          end;
        mbIgnore:
          begin
            bt.Caption := '';
            bt.ModalResult := mrIgnore;
          end;
        mbAll:
          begin
            bt.Caption := '';
            bt.ModalResult := mrAll;
          end;
        mbNoToAll:
          begin
            bt.Caption := '  ';
            bt.ModalResult := mrNoToAll;
          end;
        mbYesToAll:
          begin
            bt.Caption := '  ';
            bt.ModalResult := mrYesToAll;
          end;
        mbHelp:
          begin
            bt.Caption := '';
            bt.ModalResult := mrNone;
          end;
      end;

      inc(i);
      if i > 3 then
        break;
    end;

  w.updateSize;
  result := w.ShowModal;
  w.Free
end;


procedure TInfoDlgForm.FormActivate(Sender: TObject);
begin
  bt2.Visible := bt2.Caption <> '';
  bt3.Visible := bt2.Visible  and  (bt3.Caption <> '');

  if not(bt2.Visible) then begin
    bt1.Left := (Width - bt1.Width) div 2;
    bt1.Cancel := True;
  end else
  if not(bt3.Visible) then begin
    bt1.Left := ((Width - bt1.Width*2 - 10) div 2) - 3;
    bt2.Left := bt1.Left + bt1.Width + 10;
    bt2.Cancel := True;
  end else
  begin
    bt3.Cancel := True;
  end;

  if Caption = '' then
    Caption := '';

  if bt1.Caption = '' then
    bt1.Caption := '';

  btResult := nil;
end;

procedure TInfoDlgForm.FormCreate(Sender: TObject);
begin
  Height := 224;
  Width := 486;
end;

procedure TInfoDlgForm.updateSize;
begin
  lbHelper.Caption := lb.Caption;
  if (lbHelper.Width < 235) and (lbHelper.Height < 90) then begin
    Height := 210;
    if bt3.Visible then
      Width := 480
    else
      Width := 326;
  end;

  Left := (Form1.Width - Width) div 2;
  Top := (Form1.Height - Height) div 2;
end;

procedure TInfoDlgForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
//  if btResult = nil then
//    ModalResult := 3;

  //ShowMessage(IntToStr(ModalResult));
end;

procedure TInfoDlgForm.btClick(Sender: TObject);
begin
  btResult := sender as TAdvGlowButton;
end;

end.
