unit rpTcpClient;

interface
uses
  Controls,
  inifiles,
  TcpPortHolder,
  TcpImportClient;


type
  TrpTcpClient = class
  public
    port: TTcpPortHolder;
    client: TTcpImportClientModule;
    Connected: boolean;

    constructor Create;
    destructor Destroy; override;

    procedure Load(IniFileName: string; IniGroupName: string); virtual;
    procedure Save(IniFileName: string; IniGroupName: string); virtual;

    function GetCfg: string;
    procedure SetCfg(s: string);

    procedure Start;
    procedure Stop;
    function EditProp: boolean;
  end;

implementation
uses
  rpTcpClientProp;

{ TrpTcpClient }

function TrpTcpClient.EditProp: boolean;
var
  w: TrpTcpClientPropForm;
begin
  w := TrpTcpClientPropForm.Create(nil);
  try
    w.P := port;
    w.M := client;
    result := w.ShowModal = mrOk;
  finally
    w.Free;
  end;
end;

function TrpTcpClient.GetCfg: string;
var
  s1,s2: string;
begin
  port.GetCfg(s1);
  client.GetCfg(s2);
  result := s1+s2;
end;

procedure TrpTcpClient.SetCfg(s: string);
begin
  port.SetCfg(s);
  client.SetCfg(s);
end;

constructor TrpTcpClient.Create;
begin
  Connected := false;
  port := TTcpPortHolder.Create;
  client := TTcpImportClientModule.Create;
  port.AddModule(client);
end;

destructor TrpTcpClient.Destroy;
begin
  port.Free;
  inherited;
end;

procedure TrpTcpClient.Load(IniFileName: string; IniGroupName: string);
var
  ini: TIniFile;
begin
  ini := Tinifile.Create(IniFileName);
  port.Load(ini, IniGroupName);
  client.Load(ini, IniGroupName);
  ini.Free;
end;

procedure TrpTcpClient.Save(IniFileName: string; IniGroupName: string);
var
  ini: TIniFile;         
begin
  ini := Tinifile.Create(IniFileName);
  port.Save(ini, IniGroupName);
  client.Save(ini, IniGroupName);        
  ini.Free;
end;

procedure TrpTcpClient.Start;
begin
  Connected := true;
  port.Init;
  port.StartAfterInit;
  client.FirstPass;
end;
                              
procedure TrpTcpClient.Stop;
begin
  if port.Working then
    port.Stop;

  if port.Thrd <> nil then begin
    port.Thrd.Terminate;
    port.Thrd.WaitFor;
  end;

  Connected := false;
end;

end.
