unit rpTcpClientProp;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, Mask, TcpPortHolder, TcpImportClient;

type
  TrpTcpClientPropForm = class(TForm)
    Label7: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    cbEmmulate: TCheckBox;
    edPeriod: TEdit;
    cbEnable: TCheckBox;
    edHost: TEdit;
    edPort: TEdit;
    edTimeReconnect: TEdit;
    Label4: TLabel;
    Label6: TLabel;
    Label8: TLabel;
    NameEdit: TMaskEdit;
    AttempMaxEdit: TMaskEdit;
    edTagFilterStr: TMaskEdit;
    cbReadOnly: TCheckBox;
    OkButton: TButton;
    CancelButton: TButton;
    Bevel1: TBevel;
    Label5: TLabel;
    Bevel2: TBevel;
    Label9: TLabel;
    procedure FormActivate(Sender: TObject);
    procedure OkButtonClick(Sender: TObject);
//    procedure btOpcTagnameParserConfigClick(Sender: TObject);
  private
    { Private declarations }
  public
    P: TTcpPortHolder;
    M: TTcpImportClientModule;
  end;

var
  rpTcpClientPropForm: TrpTcpClientPropForm;

implementation
uses
  numbers;
//  OpcTagnameParser;

{$R *.dfm}

procedure TrpTcpClientPropForm.FormActivate(Sender: TObject);
begin
  if P = nil then exit;
  if M=nil then exit;

  cbEnable.Checked := P.Enable;
  cbEmmulate.Checked := P.EmmulateMode;
  edPeriod.Text := inttostr(P.Period);

  edHost.Text := P.Host;
  edPort.Text := inttostr(P.Port);
  edTimeReconnect.Text := inttostr(P.TimeReconnect);

  NameEdit.Text := M.Name;
  AttempMaxEdit.Text := IntToStr(M.AttempMax);
  cbReadOnly.Checked := M.ReadOnly;
  edTagFilterStr.Text := M.TagFilterStr;
end;

procedure TrpTcpClientPropForm.OkButtonClick(Sender: TObject);
var
  i,v: integer;
begin
  P.Enable := cbEnable.Checked;
  P.EmmulateMode := cbEmmulate.Checked;

  val(edPeriod.Text, v, i);
  P.Period := v;

  P.Host := edHost.Text;

  val(edPort.Text, v, i);
  P.Port := v;

  val(edTimeReconnect.Text, v, i);
  P.TimeReconnect := v;

  
  NameEdit.Text := UpperCase(NameEdit.Text);
  M.Name := NameEdit.Text;
  val(AttempMaxEdit.Text, M.AttempMax, i);
  M.Enable := cbEnable.Checked;
  M.EmmulateModule := cbEmmulate.Checked;
  M.ReadOnly := cbReadOnly.Checked;
  M.TagFilterStr := edTagFilterStr.Text;


  ModalResult := mrOk;
end;

{
procedure TrpTcpClientPropForm.btOpcTagnameParserConfigClick(Sender: TObject);
var
  prs: TOpcTagnameParser;
begin
  prs := TOpcTagnameParser.Create;
  try
    prs.Text := m.TagNameParserCfg;
    if prs.ConfigDialog(self) then
      m.TagNameParserCfg := prs.Text;
  finally
    prs.Free;
  end;
end;
}

end.
