unit AngleLabel;

interface
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type

  TAngleLabel = class(TLabel)
  private
    FUpdown: boolean;
    FOffsetX: Integer;
    FOffsetY: Integer;
    FAutoFontColor: boolean;
    procedure SetUpdown(value: boolean);
    procedure SetOffsetX(value: integer);
    procedure SetOffsetY(value: integer);
    procedure SetAutoFontColor(value: boolean);
  protected
    procedure Paint; override;
  published
    property Updown: boolean read FUpdown write SetUpdown;
    property OffsetX: integer read FOffsetX write SetOffsetX;
    property OffsetY: integer read FOffsetY write SetOffsetY;
    property AutoFontColor: boolean read FAutoFontColor write SetAutoFontColor;
  end;

implementation

procedure AngleTextOut(ACanvas: TCanvas; Angle, X, Y: Integer; Str: string);
var
  LogRec: TLogFont;
  OldFontHandle,
  NewFontHandle: hFont;
begin
  GetObject(ACanvas.Font.Handle, SizeOf(LogRec), Addr(LogRec));
  LogRec.lfEscapement := Angle*10;
  NewFontHandle := CreateFontIndirect(LogRec);
  OldFontHandle := SelectObject(ACanvas.Handle, NewFontHandle);
  ACanvas.TextOut(X, Y, Str);
  NewFontHandle := SelectObject(ACanvas.Handle, OldFontHandle);
  DeleteObject(NewFontHandle);
end;


procedure TAngleLabel.Paint;
var
  r: TRect;
  angle: integer;
//  intensity: Integer;
  d: Double;
begin

  angle := 0;
  r.Left := 0;
  r.Top := 0;
  r.Right := Width;
  r.Bottom := Height;
  Canvas.Brush.Color := Color;
  Canvas.FillRect(r);
  Canvas.Font.Assign(Font);


  d := (Color and $FF) * 0.299 + ((Color shr 8) and $FF) * 0.587 + ((Color shr 16) and $FF) * 0.114;
  if FAutoFontColor then begin
    if d > 149.0 then
      Canvas.Font.Color := clBlack
    else
      Canvas.Font.Color := clWhite;
  end;

  if not FUpdown then begin
    angle := 90;
    case Alignment of
      taLeftJustify:
        r.Left := 0;
      taRightJustify:
        r.Left := Width - Canvas.TextHeight(Caption);
      taCenter:
        r.Left := (Width - Canvas.TextHeight(Caption)) div 2;
    end;

    case Layout of
      tlBottom:
        r.Top := Height;
      tlTop:
        r.Top := Canvas.TextWidth(Caption);
      tlCenter:
        begin
          r.Top := Height - (Height - Canvas.TextWidth(Caption)) div 2;
          if r.Top > Height then
            r.Top := Height;
        end;
    end;
  end;

  if FUpdown then begin
    angle := -90;
    case Alignment of
      taLeftJustify:
        r.Left := Canvas.TextHeight(Caption) + 0;
      taRightJustify:
        r.Left := Width;
      taCenter:
        r.Left := Width - (Width - Canvas.TextHeight(Caption)) div 2;
    end;

    case Layout of
      tlTop:
        r.Top := 0;
      tlBottom:
        r.Top := Height - Canvas.TextWidth(Caption);
      tlCenter:
        begin
          r.Top := (Height - Canvas.TextWidth(Caption)) div 2;
          if r.Top < 0 then
            r.Top := 0;
        end;
    end;
  end;

  Inc(r.Left, FOffsetX);
  Inc(r.Top, FOffsetY);

  AngleTextOut(Canvas, angle, r.Left, r.Top, Caption);
end;



procedure TAngleLabel.SetAutoFontColor(value: boolean);
begin
  FAutoFontColor := value;
  Invalidate;
end;

procedure TAngleLabel.SetOffsetX(value: integer);
begin
  FOffsetX := value;
  Invalidate;
end;

procedure TAngleLabel.SetOffsetY(value: integer);
begin
  FOffsetY := value;
  Invalidate;
end;

procedure TAngleLabel.SetUpdown(value: boolean);
begin
  FUpdown := value;
  Invalidate;
end;

end.
