unit rpMessages;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls;

type
  TrpShowMessageForm = class(TForm)
    lbMessage: TLabel;
    btClose: TBitBtn;
    Bevel1: TBevel;
    Timer: TTimer;
    btNoClose: TBitBtn;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
    procedure btCloseClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure btNoCloseClick(Sender: TObject);
  private
  public
    Cnt: integer;
    AutoClose: boolean;
    procedure StartCountDown(Secs: integer; WithClosing: boolean);
  end;

  function rpCreateMessage(s: string): TrpShowMessageForm;

implementation

{$R *.DFM}

function rpCreateMessage(s: string): TrpShowMessageForm;
var
  W: TrpShowMessageForm;
begin
  W := TrpShowMessageForm.Create(Application.MainForm);
  with W do begin
    lbMessage.Caption := s;
    Show;
  end;
  result := W;
end;


procedure TrpShowMessageForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Release;
end;

procedure TrpShowMessageForm.FormShow(Sender: TObject);
begin
  Left := Left + (Width - lbMessage.Left*2 - lbMessage.Width) div 2;
  Top := Top + (Height - lbMessage.Top*2 - lbMessage.Height) div 2;
  Width := lbMessage.Left*2 + lbMessage.Width + 8;
  Height := lbMessage.Top*2 + lbMessage.Height + 55;
end;

procedure TrpShowMessageForm.btCloseClick(Sender: TObject);
begin
  close;
end;

procedure TrpShowMessageForm.FormCreate(Sender: TObject);
begin
  Caption := ' - ' + DateTimeToStr(now);
  Cnt := 0;
  AutoClose := false;
end;

procedure TrpShowMessageForm.TimerTimer(Sender: TObject);
begin
  if Cnt > 0 then begin
    dec(Cnt);
    btClose.Caption := ' ' + inttostr(Cnt);
  end else begin
    Timer.Enabled := false;
    btNoCloseClick(nil);
//    btClose.Caption := '';
//    btNoClose.Visible := false;
    if AutoClose then btCloseClick(nil);
  end;
end;

procedure TrpShowMessageForm.StartCountDown(Secs: integer; WithClosing: boolean);
begin
  Cnt := Secs;
  AutoClose := WithClosing;
  btClose.Caption := ' ' + inttostr(Cnt);
  Timer.Enabled := true;
  btNoClose.Visible := true;
end;


procedure TrpShowMessageForm.btNoCloseClick(Sender: TObject);
begin
  btClose.Caption := '';
  Timer.Enabled := false;
  btNoClose.Visible := false;
end;

end.
