unit logger;

interface
uses SysUtils, forms;

  procedure LoggerInit;
  procedure LoggerSaveMessage(s: string);
  procedure LoggerSaveDate;
  function LoggerLoadDate: TDatetime;

implementation
var
  fname_log, fname_tmp: string;

procedure LoggerInit;
begin
  fname_log := ChangeFileExt(Application.ExeName, '.log');
  fname_tmp := ChangeFileExt(Application.ExeName, '.logger.tmp');
end;


procedure LoggerSaveMessage(s: string);
var
  F: Textfile;
begin
  AssignFile(F, fname_log);
  try
    if FileExists(fname_log) then
      Append(F)
    else
      rewrite(F);
    Writeln(F, DateTimeToStr(now) + ': ' +  s);
  except
  end;

  try
    CloseFile(F);
  except
  end;
end;

procedure LoggerSaveDate;
var
  F: file of TDatetime;
  dt: TDatetime;
begin
  AssignFile(F, fname_tmp);
  try
    Rewrite(F);
    dt := now;
    Write(F, dt);
  except
  end;

  try
    CloseFile(F);
  except
  end;
end;

function LoggerLoadDate: TDatetime;
var
  F: file of TDatetime;
  dt: TDatetime;
begin
  AssignFile(F, fname_tmp);
  try
    reset(F);
    read(F, dt);
  except
  end;

  try
    CloseFile(F);
  except
  end;

  result := dt;
end;

end.
