unit CustomScadaObjectScriptEdit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ScadaBase, SynEditHighlighter, SynHighlighterPas, SynEdit,
  SynMemo, StdCtrls, ExtCtrls;

type
  TCustomScadaObjectScriptEditForm = class(TForm)
    memo: TSynMemo;
    SynPasSyn1: TSynPasSyn;
    Panel1: TPanel;
    btCompile: TButton;
    btOk: TButton;
    btCancel: TButton;
    btExec: TButton;
    mesmemo: TMemo;
    Splitter1: TSplitter;
    procedure btCompileClick(Sender: TObject);
  private
    { Private declarations }
  public
    CustomScadaObject: TCustomScadaObject;
  end;

  function ShowScriptEdit(aCustomScadaObject: TCustomScadaObject):boolean;

var
  CustomScadaObjectScriptEditForm: TCustomScadaObjectScriptEditForm;

implementation

{$R *.dfm}



function ShowScriptEdit(aCustomScadaObject: TCustomScadaObject):boolean;
begin
  CustomScadaObjectScriptEditForm:= TCustomScadaObjectScriptEditForm.Create(Application);
  with CustomScadaObjectScriptEditForm do begin
    CustomScadaObject := aCustomScadaObject;
    Caption := '  - ' + aCustomScadaObject.ClassName + '.' + aCustomScadaObject.Name;  
    memo.Text := aCustomScadaObject.Script.Text;

    Result:=ShowModal = mrOk;
    if Result then
      aCustomScadaObject.Script.Text:=memo.Text;

    Free
  end;
end;


procedure TCustomScadaObjectScriptEditForm.btCompileClick(Sender: TObject);
var
  tmp_script, messages: string;
begin
  tmp_script := CustomScadaObject.Script.Text;
  CustomScadaObject.Script.Text:=memo.Text;
  try
    CustomScadaObject.CompileScript(messages);
    mesmemo.Text := messages;
    if sender = btExec then CustomScadaObject.ExecuteScript;
  finally
    CustomScadaObject.Script.Text:=tmp_script;
  end;
end;

end.
