unit VisLabelScriptEdit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, VisLabel, SynEditHighlighter, SynHighlighterPas, SynEdit,
  SynMemo, StdCtrls, ExtCtrls;

type
  TVisLabelScriptEditForm = class(TForm)
    memo: TSynMemo;
    SynPasSyn1: TSynPasSyn;
    Panel1: TPanel;
    btCompile: TButton;
    btOk: TButton;
    btCancel: TButton;
    btExec: TButton;
    mesmemo: TMemo;
    Splitter1: TSplitter;
    procedure btCompileClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure memoChange(Sender: TObject);
  private
    { Private declarations }
    HasChanges: boolean;
  public
    VisLabel:TVisLabel;
  end;

  function ShowScriptEdit(aVisLabel:TVisLabel):boolean;

var
  VisLabelScriptEditForm: TVisLabelScriptEditForm;

implementation

{$R *.dfm}



function ShowScriptEdit(aVisLabel:TVisLabel):boolean;
begin
  VisLabelScriptEditForm:= TVisLabelScriptEditForm.Create(Application);
  with VisLabelScriptEditForm do begin
    VisLabel := aVisLabel;
    Caption := '  - ' + aVisLabel.ClassName + '.' + aVisLabel.Name;  
    memo.Text := aVisLabel.Script.Text;

    Result:=ShowModal = mrOk;
    if Result then
      aVisLabel.Script.Text:=memo.Text;

    Free
  end;
end;


procedure TVisLabelScriptEditForm.btCompileClick(Sender: TObject);
var
  tmp_script, messages: string;
begin
  tmp_script := VisLabel.Script.Text;
  VisLabel.Script.Text:=memo.Text;
  try
    VisLabel.CompileScript(messages);
    mesmemo.Text := messages;
    if sender = btExec then VisLabel.ExecuteScript;
  finally
    VisLabel.Script.Text:=tmp_script;
  end;
end;

procedure TVisLabelScriptEditForm.FormCreate(Sender: TObject);
begin
  HasChanges := false;
end;

procedure TVisLabelScriptEditForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
var
  i: integer;
begin
  if not HasChanges then exit;

  i := MessageDlg('   ?', mtConfirmation, mbYesNoCancel, 0);
  case i of
    mrYes: begin
        ModalResult := mrOk;
        CanClose := true;
      end;
    mrNo: begin
        CanClose := true;
      end;
    else
      CanClose := false;
  end;

end;

procedure TVisLabelScriptEditForm.memoChange(Sender: TObject);
begin
  HasChanges := true;
end;

end.
