unit VisSeqcControl;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ScadaBase, VisButton, VisLabel, VisDataboard, ExtCtrls,
  Buttons, VisSeqc, VisControl;

type
  TSeqcControlForm = class(TForm)
    btStart: TVisButton;
    btStop: TVisButton;
    lbName: TLabel;
    pnl1: TPanel;
    btEmrg: TVisButton;
    seqc: TVisSeqc;
    cmb: TComboBox;
    VisLabel1: TVisLabel;
    procedure VisLabel1Process(Sender: TObject);
    procedure btStartCanClick(Sender: TObject; var Can: Boolean);
    procedure btStartClick(Sender: TObject);
    procedure btStopClick(Sender: TObject);
    procedure cmbClick(Sender: TObject);
  private
    updateIsNeeded: Boolean;
    procedure groupUpdateCombo;
  end;

  function createVisSeqcControl(pnl: TWinControl; dbNamePrm: string;
        TagPath: string; TagRoot: string; SeqcName: string): TSeqcControlForm;

  procedure setSeqcControlComboUpdateNotification;


implementation

uses
  Users,
  MesLogging,
  VisSeqcApi,
  VisSeqcConnection,
  TagStorage,
  _PrjProcs,
  RpVisualLegacyPanels,
  RpVisualMain,
  RpVisualGlobal;


var
  seqcControlList: array of TSeqcControlForm;
  updateIsAllowed: Boolean;

  _TagPath: string;
  _TagRoot: string;

{$R *.dfm}

procedure setSeqcControlComboUpdateNotification;
var
  i,n: Integer;
begin
  updateIsAllowed := true;
  n := Length(seqcControlList);
  for i:=0 to n-1 do
    seqcControlList[i].updateIsNeeded := True;
end;


procedure _initproc(Target: TCustomScadaObject);
begin
  Target.TagPath := _TagPath;
  Target.TagRoot := _TagRoot;
end;


function createVisSeqcControl(pnl: TWinControl; dbNamePrm: string;
      TagPath: string; TagRoot: string; SeqcName: string): TSeqcControlForm;

  procedure _btnhint(visbtn: TVisButton);
  begin
    visbtn.Hint := SeqcName + ' - ' + visbtn.objButton.Caption;
  end;

var
  w: TSeqcControlForm;
  s: string;
  i: Integer;
begin


  // create window
  w := TSeqcControlForm.Create(pnl);

  i := Length(seqcControlList);
  SetLength(seqcControlList, i+1);
  seqcControlList[i] := w;

  w.Parent := pnl;
  w.Align := alClient;
  w.Visible := true;
  w.BorderStyle := bsNone;
  w.Show;

  if pnl is TPanel then
    w.Color := (pnl as TPanel).Color;
  result := w;

  // init scada controls
  if TagPath = '' then
    TagPath := _PrjCodeName;
  _TagPath := TagPath;
  _TagRoot := TagRoot;
  CustomScanScadaObjects(w, _initproc);
  CustomScanScadaObjects(w, InitDeviceProc);

  w.seqc.DBNameParam := dbNamePrm;
  w.seqc.Visible := False;
//  w.seqc.Top := 5;

  w.lbName.Caption := SeqcName;
  _btnhint(w.btStart);
  _btnhint(w.btStop);
  _btnhint(w.btEmrg);

  w.updateIsNeeded := true;
  updateIsAllowed := True;

  w.Hint := SeqcName + #13' (' + w.seqc.TagPath + '.' + w.seqc.TagRoot + ', ' + dbNamePrm + ')';
end;


procedure TSeqcControlForm.groupUpdateCombo;
var
  i,n: Integer;
  dbnameprm: string;
  conn: TSeqcConnection;
  connOk: Boolean;
begin
  updateIsAllowed := False;
  
  n := Length(seqcControlList);

  repeat
    dbnameprm := '';
    conn := nil;
    for i:=0 to n-1 do
      if seqcControlList[i].updateIsNeeded then begin
        if conn = nil then begin
          dbnameprm := seqcControlList[i].seqc.DBNameParam;
          conn := TSeqcConnectionImpl.create(dbnameprm);
        end;

        if dbnameprm = seqcControlList[i].seqc.DBNameParam then begin
          if conn.isConnected then
            conn.getRootListCombobox(
                  seqcControlList[i].cmb,
                  '*'+seqcControlList[i].lbName.Caption+'*',
                  seqcControlList[i].seqc.TagPath,
                  seqcControlList[i].seqc.TagRoot
                );
          seqcControlList[i].updateIsNeeded := False;
        end;
      end;

    if conn<>nil then
      conn.Free
    else
      Break;
  until false;

end;


procedure TSeqcControlForm.btStartCanClick(Sender: TObject;
  var Can: Boolean);
var
  conn: TSeqcConnection;
begin
  Can := false;
  if cmb.ItemIndex=-1 then Exit;
  if MessageDlg('  "' + cmb.Text + '"?', mtConfirmation,
        mbOKCancel, 0)<>mrOk then exit;


  if seqc.Sost > 0 then begin
    Can := True;
    Exit;
  end;

  conn := TSeqcConnectionImpl.create(seqc.DBNameParam);
  Can := conn.installRoot(Integer(cmb.Items.Objects[cmb.ItemIndex]), seqc.TagPath, seqc.TagRoot );
  if Can then begin
    can := seqc.CheckRootDevicesBeforeStart;
  end;
  conn.Free;
end;


procedure TSeqcControlForm.btStartClick(Sender: TObject);
begin
  SaveMessageText(' ', cmb.Text, '', $00A2EE44);
end;


procedure TSeqcControlForm.btStopClick(Sender: TObject);
begin
  SaveMessageText(' ', seqc.objLabel.Caption, (Sender as TVisButton).CaptionDown, $00F0D642);
end;



procedure TSeqcControlForm.VisLabel1Process(Sender: TObject);
begin
//  lbName.Caption := lbName.Caption + '*';

  if updateIsAllowed then
    groupUpdateCombo;

  seqc.Visible := seqc.Sost > 0;
  if seqc.Visible then
    seqc.objButton.Visible := CurUserId = USER_SUPERVISOR;


end;


procedure TSeqcControlForm.cmbClick(Sender: TObject);
begin
  iniSaveRootCodeCombobox(cmb, seqc.TagPath, seqc.TagRoot);
end;

end.
