unit VisTrackBarScriptEdit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, VisTrackBar, SynEditHighlighter, SynHighlighterPas, SynEdit,
  SynMemo, StdCtrls, ExtCtrls;

type
  TVisTrackBarScriptEditForm = class(TForm)
    memo: TSynMemo;
    SynPasSyn1: TSynPasSyn;
    Panel1: TPanel;
    btCompile: TButton;
    btOk: TButton;
    btCancel: TButton;
    btExec: TButton;
    mesmemo: TMemo;
    Splitter1: TSplitter;
    procedure btCompileClick(Sender: TObject);
  private
    { Private declarations }
  public
    VisTrackBar:TVisTrackBar;
  end;

  function ShowScriptEdit(aVisTrackBar:TVisTrackBar):boolean;

var
  VisTrackBarScriptEditForm: TVisTrackBarScriptEditForm;

implementation

{$R *.dfm}



function ShowScriptEdit(aVisTrackBar:TVisTrackBar):boolean;
begin
  VisTrackBarScriptEditForm:= TVisTrackBarScriptEditForm.Create(Application);
  with VisTrackBarScriptEditForm do begin
    VisTrackBar := aVisTrackBar;
    Caption := '  - ' + aVisTrackBar.ClassName + '.' + aVisTrackBar.Name;  
    memo.Text := aVisTrackBar.Script.Text;

    Result:=ShowModal = mrOk;
    if Result then
      aVisTrackBar.Script.Text:=memo.Text;

    Free
  end;
end;


procedure TVisTrackBarScriptEditForm.btCompileClick(Sender: TObject);
var
  tmp_script, messages: string;
begin
  tmp_script := VisTrackBar.Script.Text;
  VisTrackBar.Script.Text:=memo.Text;
  try
    VisTrackBar.CompileScript(messages);
    mesmemo.Text := messages;
    if sender = btExec then VisTrackBar.ExecuteScript;
  finally
    VisTrackBar.Script.Text:=tmp_script;
  end;
end;

end.
