unit TermoTable;

interface
uses graphics, AdvCGrid, dialogs, sysutils, Classes;

type
  TTermoPodves = class
    tagname: array of string;
    tagidx: array of integer;
    value: array of integer;
    maxvalue: integer;
    name: string;
    divider: integer;
  public
    constructor CreatePodves(name: string; divider: integer; tagtmpl: string; tags: string);
  end;


  PTermoStateRec =^TTermoStateRec;
  TTermoStateRec = record
    low: integer;
    high: integer;
    bckgcolor: TColor;
    fontcolor: TColor;
    msg: string;
  end;

  
  TTermoTable = class
    procedure ClickCell(Sender: TObject; ARow, ACol: Integer);
  private
    firstpass: boolean;
    grid: TAdvColumnGrid;
    state: array of PTermoStateRec;
    stateCount: integer;
    podves: array of TTermoPodves;
  private
    procedure updateColor(col, row, value: integer);
  public
    constructor CreateTable(grid: TAdvColumnGrid);
    destructor Destroy;
    procedure addState(low: integer; high: integer; bckgcolor: TColor; fontcolor: TColor; msg: string);
    procedure addPodves(name: string; divider: integer; tagtmpl: string; tags: string);
    procedure init;
    procedure update;
    function getMaxFromPodves(iPodves:integer):integer;
  end;

implementation
uses
  Status,
  TrendWindow,
  tagstorage,
  hyperstr;

{ TTermoTable }

procedure TTermoTable.addstate(low, high: integer; bckgcolor,
  fontcolor: TColor; msg: string);
var
  i: integer;
begin
  i := length(state);
  stateCount := i+1;
  setlength(state, stateCount);
  new(state[i]);
  state[i].low := low;
  state[i].high := high;
  state[i].bckgcolor := bckgcolor;
  state[i].fontcolor := fontcolor;
  state[i].msg := msg;

end;



procedure TTermoTable.addPodves(name: string; divider: integer; tagtmpl,
  tags: string);
var
  i: integer;
begin
  i := length(podves);
  setlength(podves, i+1);
  podves[i] := TTermoPodves.CreatePodves(name, divider, tagtmpl, tags);
end;



constructor TTermoTable.CreateTable(grid: TAdvColumnGrid);
begin
  self.grid := grid;
end;



destructor TTermoTable.Destroy;
var
  i: integer;
begin
  for i:=0 to length(podves)-1 do
    podves[i].Free;
  podves := nil;

  for i:=0 to length(state)-1 do
    dispose(state[i]);
  state := nil;

end;





procedure TTermoTable.ClickCell(Sender: TObject; ARow, ACol: Integer);
var
  p,d: integer;
begin
  p := ARow-1;
  d := ACol-1;
  if (p < length(podves)) and (p>=0) then
    if (d < length(podves[p].tagname)) and (d>=0) then begin
      ShowTrendWindow(
        podves[p].name + '  ' + grid.Columns[ACol].Header,
        podves[p].tagname[d],
        '',
        'termo_',
        '',
        ''
      );
    end;
end;


function TTermoTable.getMaxFromPodves(iPodves: integer): integer;
begin
   if iPodves>=length(podves) then result:=-1;
   result:=podves[iPodves].maxvalue;
end;

{ TTermoPodves }

constructor TTermoPodves.CreatePodves(name: string; divider: integer;
  tagtmpl, tags: string);
var
  i,k,rootidx: integer;
  s: string;
begin
  self.name := name;
  self.divider := divider;
  self.maxvalue :=0;

  rootidx := pos('^', tagtmpl);
  delete(tagtmpl, rootidx, 1);

  if rootidx>0 then
    while tags<>'' do begin
      k:=pos(';', tags);
      if k=0 then begin
        s:=tags;
        tags:='';
      end else begin
        s:=copy(tags, 1, k-1);
        delete(tags, 1, k);
      end;

      if s<>'' then begin
        i:= length(tagname);
        setlength(tagname, i+1);

        tagname[i] := tagtmpl;
        insert(s, tagname[i], rootidx);
      end;
    end;
end;


procedure TTermoTable.init;
var
  i,j,k,n: integer;
begin
  Status.ShowStatusMessage(' ');
  grid.Color := grid.GridLineColor;
  grid.RowCount := length(podves)+1;

  k:=0;
  for i:=0 to length(podves)-1 do
    if length(podves[i].tagname) > k then
      k := length(podves[i].tagname);
  grid.ColCount := k+1;

  for i:=0 to length(podves)-1 do begin
    grid.Cells[0, i+1] := podves[i].name;

    n := length(podves[i].tagname);
    setlength(podves[i].tagidx, n);
    setlength(podves[i].value, n);
    for j:=0 to n-1 do begin
      podves[i].tagidx[j] := gettagindex(podves[i].tagname[j]);
      podves[i].value[j] := gettagvalue(podves[i].tagidx[j]);
    end;
    podves[i].maxvalue:=0;
    for j:=n to grid.ColCount-2 do begin
      grid.CellProperties[j+1,i+1].BrushColor := grid.GridLineColor;
    end;

  end;

  for i:=0 to k-1 do begin
    grid.Columns[i+1].HeaderFont.Style := [fsBold];
    grid.Columns[i+1].HeaderAlignment := taCenter;
    grid.Columns[i+1].Alignment := taRightJustify;
    grid.Columns[i+1].ReadOnly := true;
  end;

  grid.OnDblClickCell := ClickCell;
  firstpass := true;
  Status.CloseStatusMessage;
end;



procedure TTermoTable.update;
var
  i,j,k,n,v: integer;
  flag: boolean;
begin
  for i:=0 to length(podves)-1 do
    with podves[i] do begin
      n := length(podves[i].tagidx);
      for j:=0 to n-1 do begin

        flag := false;
        if tagidx[j]>=0 then begin
          if value[j] <> gettagvalue(tagidx[j]) then
          begin
            value[j] := gettagvalue(tagidx[j]);
            flag := true;
          end;
          if maxvalue< value[j] then maxvalue:=value[j];
          if (firstpass) or (flag) then begin
            v := round( value[j] / divider);
            grid.Cells[j+1, i+1] := inttostr(v);
            updateColor(j+1, i+1, v);
          end;

        end else
          if firstpass then
            grid.Cells[j+1,i+1] := 'tag';  


      end;
    end;

  firstpass := false;
end;


procedure TTermoTable.updateColor(col, row, value: integer);
var
  i: integer;
begin
  for i:=0 to stateCount-1 do
    if (value >= state[i].low) and (value <= state[i].high) then begin
      grid.CellProperties[col, row].BrushColor := state[i].bckgcolor;
      grid.CellProperties[col, row].FontColor := state[i].fontcolor;
      if state[i].msg <> '' then
        grid.Cells[col, row] := state[i].msg;
      break;
    end;
end;


end.

