{ Compiletime STDCtrls support }
unit uPSC_visscada; 

{$I PascalScript.inc}
interface
uses
  uPSCompiler, uPSUtils;

procedure SIRegister_visscada_TypesAndConsts(cl: TPSPascalCompiler);

procedure SIRegisterTCUSTOMSCADAOBJECT(Cl: TPSPascalCompiler);
procedure SIRegisterTVISLABEL(Cl: TPSPascalCompiler);
procedure SIRegisterTVISCHECKBOX(Cl: TPSPascalCompiler);
procedure SIRegisterTVISCOMBOBOX(Cl: TPSPascalCompiler);
procedure SIRegisterTVISTRACKBAR(Cl: TPSPascalCompiler);
procedure SIRegisterTVISRADIOBUTTON(Cl: TPSPascalCompiler);
procedure SIRegisterTVISNUMERICPANEL(Cl: TPSPascalCompiler);
procedure SIRegisterTVISDATABOARD(Cl: TPSPascalCompiler);

procedure SIRegister_visscada(cl: TPSPascalCompiler);


implementation



procedure SIRegisterTCUSTOMSCADAOBJECT(Cl: TPSPascalCompiler);
begin
  with Cl.AddClassN(cl.FindClass('TCUSTOMCONTROL'), 'TCUSTOMSCADAOBJECT') do
  begin
//    RegisterMethod('procedure Init;');
//    RegisterMethod('procedure Process;');
  end;
end;  

procedure SIRegisterTVISLABEL(Cl: TPSPascalCompiler);
begin
  with Cl.AddClassN(cl.FindClass('TCUSTOMSCADAOBJECT'), 'TVISLABEL') do
  begin
    RegisterProperty('OBJLABEL', 'TLabel', iptrw);
    RegisterProperty('OBJSHAPE', 'TShape', iptrw);
    RegisterProperty('TAGNAMES', 'TStringList', iptrw);
    RegisterProperty('TAGPATH',  'String', iptrw);
    RegisterProperty('TAGROOT',  'String', iptrw);
    RegisterMethod('procedure settagval(AIndex: integer; AValue: integer);');
    RegisterMethod('function gettagval(AIndex: integer): integer;');
    RegisterMethod('procedure FloatCaption(X: double; width, decimals: integer);');
    RegisterMethod('procedure setcolors(AFontColor: integer; ABackColor: integer);');

    RegisterMethod('procedure settagvalbool(AIndex: integer; AValue: boolean);');
    RegisterMethod('function gettagvalbool(AIndex: integer): boolean;');

    RegisterMethod('procedure settagvalint(AIndex: integer; AValue: integer);');
    RegisterMethod('function gettagvalint(AIndex: integer): integer;');

    RegisterMethod('procedure settagvallong(AIndex: integer; AValue: int64);');
    RegisterMethod('function gettagvallong(AIndex: integer): int64;');

    RegisterMethod('procedure settagvaldouble(AIndex: integer; AValue: double);');
    RegisterMethod('function gettagvaldouble(AIndex: integer): double;');

    RegisterMethod('procedure settagvalstring(AIndex: integer; AValue: string);');
    RegisterMethod('function gettagvalstring(AIndex: integer): string;');

    RegisterMethod('function istaggood(AIndex: integer): boolean;');
  end;
end;

procedure SIRegisterTVISCHECKBOX(Cl: TPSPascalCompiler);
begin
  with Cl.AddClassN(cl.FindClass('TCUSTOMSCADAOBJECT'), 'TVISCHECKBOX') do
  begin
    RegisterProperty('OBJCHECKBOX', 'TCheckBox', iptrw);
    RegisterProperty('TAGNAMES', 'TStringList', iptrw);
    RegisterProperty('TAGPATH', 'String', iptrw);
    RegisterProperty('TAGROOT',  'String', iptrw);
    RegisterMethod('function IsApplying: boolean;');
    RegisterMethod('procedure settagval(AIndex: integer; AValue: integer);');
    RegisterMethod('function gettagval(AIndex: integer): integer;');
    RegisterMethod('procedure setcolors(AFontColor: integer; ABackColor: integer);');

    RegisterMethod('procedure settagvalbool(AIndex: integer; AValue: boolean);');
    RegisterMethod('function gettagvalbool(AIndex: integer): boolean;');

    RegisterMethod('procedure settagvalint(AIndex: integer; AValue: integer);');
    RegisterMethod('function gettagvalint(AIndex: integer): integer;');

    RegisterMethod('procedure settagvallong(AIndex: integer; AValue: int64);');
    RegisterMethod('function gettagvallong(AIndex: integer): int64;');

    RegisterMethod('procedure settagvaldouble(AIndex: integer; AValue: double);');
    RegisterMethod('function gettagvaldouble(AIndex: integer): double;');

    RegisterMethod('procedure settagvalstring(AIndex: integer; AValue: string);');
    RegisterMethod('function gettagvalstring(AIndex: integer): string;');

    RegisterMethod('function istaggood(AIndex: integer): boolean;');
  end;
end;

procedure SIRegisterTVISCOMBOBOX(Cl: TPSPascalCompiler);
begin
  with Cl.AddClassN(cl.FindClass('TCUSTOMSCADAOBJECT'), 'TVISCOMBOBOX') do
  begin
    RegisterProperty('OBJCOMBOBOX', 'TComboBox', iptrw);
    RegisterProperty('TAGNAMES', 'TStringList', iptrw);
    RegisterProperty('TAGPATH', 'String', iptrw);
    RegisterProperty('TAGROOT',  'String', iptrw);
    RegisterMethod('function IsApplying: boolean;');
    RegisterMethod('procedure settagval(AIndex: integer; AValue: integer);');
    RegisterMethod('function gettagval(AIndex: integer): integer;');
    RegisterMethod('procedure setcolors(AFontColor: integer; ABackColor: integer);');

    RegisterMethod('procedure settagvalbool(AIndex: integer; AValue: boolean);');
    RegisterMethod('function gettagvalbool(AIndex: integer): boolean;');

    RegisterMethod('procedure settagvalint(AIndex: integer; AValue: integer);');
    RegisterMethod('function gettagvalint(AIndex: integer): integer;');

    RegisterMethod('procedure settagvallong(AIndex: integer; AValue: int64);');
    RegisterMethod('function gettagvallong(AIndex: integer): int64;');

    RegisterMethod('procedure settagvaldouble(AIndex: integer; AValue: double);');
    RegisterMethod('function gettagvaldouble(AIndex: integer): double;');

    RegisterMethod('procedure settagvalstring(AIndex: integer; AValue: string);');
    RegisterMethod('function gettagvalstring(AIndex: integer): string;');

    RegisterMethod('function istaggood(AIndex: integer): boolean;');
  end;
end;

procedure SIRegisterTVISTRACKBAR(Cl: TPSPascalCompiler);
begin
  with Cl.AddClassN(cl.FindClass('TCUSTOMSCADAOBJECT'), 'TVISTRACKBAR') do
  begin
    RegisterProperty('OBJTRACKBAR', 'TTrackBar', iptrw);
    RegisterProperty('TAGNAMES', 'TStringList', iptrw);
    RegisterProperty('TAGPATH', 'String', iptrw);
    RegisterProperty('TAGROOT',  'String', iptrw);
    RegisterMethod('function IsApplying: boolean;');
    RegisterMethod('procedure settagval(AIndex: integer; AValue: integer);');
    RegisterMethod('function gettagval(AIndex: integer): integer;');
    RegisterMethod('procedure setcolors(AFontColor: integer; ABackColor: integer);');

    RegisterMethod('procedure settagvalbool(AIndex: integer; AValue: boolean);');
    RegisterMethod('function gettagvalbool(AIndex: integer): boolean;');

    RegisterMethod('procedure settagvalint(AIndex: integer; AValue: integer);');
    RegisterMethod('function gettagvalint(AIndex: integer): integer;');

    RegisterMethod('procedure settagvallong(AIndex: integer; AValue: int64);');
    RegisterMethod('function gettagvallong(AIndex: integer): int64;');

    RegisterMethod('procedure settagvaldouble(AIndex: integer; AValue: double);');
    RegisterMethod('function gettagvaldouble(AIndex: integer): double;');

    RegisterMethod('procedure settagvalstring(AIndex: integer; AValue: string);');
    RegisterMethod('function gettagvalstring(AIndex: integer): string;');

    RegisterMethod('function istaggood(AIndex: integer): boolean;');
  end;
end;

procedure SIRegisterTVISRADIOBUTTON(Cl: TPSPascalCompiler);
begin
  with Cl.AddClassN(cl.FindClass('TCUSTOMSCADAOBJECT'), 'TVISRADIOBUTTON') do
  begin
    RegisterProperty('OBJRADIOBUTTON', 'TRadioButton', iptrw);
    RegisterProperty('TAGNAMES', 'TStringList', iptrw);
    RegisterProperty('TAGPATH', 'String', iptrw);
    RegisterProperty('TAGROOT',  'String', iptrw);
    RegisterMethod('function IsApplying: boolean;');
    RegisterMethod('procedure settagval(AIndex: integer; AValue: integer);');
    RegisterMethod('function gettagval(AIndex: integer): integer;');
    RegisterMethod('procedure setcolors(AFontColor: integer; ABackColor: integer);');

    RegisterMethod('procedure settagvalbool(AIndex: integer; AValue: boolean);');
    RegisterMethod('function gettagvalbool(AIndex: integer): boolean;');

    RegisterMethod('procedure settagvalint(AIndex: integer; AValue: integer);');
    RegisterMethod('function gettagvalint(AIndex: integer): integer;');

    RegisterMethod('procedure settagvallong(AIndex: integer; AValue: int64);');
    RegisterMethod('function gettagvallong(AIndex: integer): int64;');

    RegisterMethod('procedure settagvaldouble(AIndex: integer; AValue: double);');
    RegisterMethod('function gettagvaldouble(AIndex: integer): double;');

    RegisterMethod('procedure settagvalstring(AIndex: integer; AValue: string);');
    RegisterMethod('function gettagvalstring(AIndex: integer): string;');

    RegisterMethod('function istaggood(AIndex: integer): boolean;');
  end;
end;


procedure SIRegisterTVISNUMERICPANEL(Cl: TPSPascalCompiler);
begin
  with Cl.AddClassN(cl.FindClass('TCUSTOMSCADAOBJECT'), 'TVISNUMERICPANEL') do
  begin
    RegisterProperty('OBJPANEL', 'TPanel', iptrw);
    RegisterProperty('TAGNAMES', 'TStringList', iptrw);
    RegisterProperty('TAGPATH', 'String', iptrw);
    RegisterProperty('TAGROOT',  'String', iptrw);
    RegisterProperty('VALUEMUL', 'integer', iptrw);
    RegisterProperty('VALUEDIV', 'integer', iptrw);
    RegisterProperty('PRECISION', 'integer', iptrw);
    RegisterProperty('READONLY', 'boolean', iptrw);
    RegisterMethod('function IsApplying: boolean;');
    RegisterMethod('procedure settagval(AIndex: integer; AValue: integer);');
    RegisterMethod('function gettagval(AIndex: integer): integer;');
    RegisterMethod('procedure setcolors(AFontColor: integer; ABackColor: integer);');

    RegisterMethod('procedure settagvalbool(AIndex: integer; AValue: boolean);');
    RegisterMethod('function gettagvalbool(AIndex: integer): boolean;');

    RegisterMethod('procedure settagvalint(AIndex: integer; AValue: integer);');
    RegisterMethod('function gettagvalint(AIndex: integer): integer;');

    RegisterMethod('procedure settagvallong(AIndex: integer; AValue: int64);');
    RegisterMethod('function gettagvallong(AIndex: integer): int64;');

    RegisterMethod('procedure settagvaldouble(AIndex: integer; AValue: double);');
    RegisterMethod('function gettagvaldouble(AIndex: integer): double;');

    RegisterMethod('procedure settagvalstring(AIndex: integer; AValue: string);');
    RegisterMethod('function gettagvalstring(AIndex: integer): string;');

    RegisterMethod('function istaggood(AIndex: integer): boolean;');
  end;
end;


procedure SIRegisterTVISDATABOARD(Cl: TPSPascalCompiler);
begin
  with Cl.AddClassN(cl.FindClass('TCUSTOMSCADAOBJECT'), 'TVISDATABOARD') do
  begin
    RegisterProperty('CAPTION',  'String', iptrw);
    RegisterProperty('OBJLABEL', 'TLabel', iptrw);
    RegisterProperty('OBJSHAPE', 'TShape', iptrw);
    RegisterProperty('TAGNAMES', 'TStringList', iptrw);
    RegisterProperty('TAGPATH',  'String', iptrw);
    RegisterProperty('TAGROOT',  'String', iptrw);
    RegisterMethod('procedure settagval(AIndex: integer; AValue: integer);');
    RegisterMethod('function gettagval(AIndex: integer): integer;');
    RegisterMethod('procedure FloatCaption(X: double; width, decimals: integer);');
    RegisterMethod('procedure setcolors(AFontColor: integer; ABackColor: integer);');

    RegisterMethod('procedure settagvalbool(AIndex: integer; AValue: boolean);');
    RegisterMethod('function gettagvalbool(AIndex: integer): boolean;');

    RegisterMethod('procedure settagvalint(AIndex: integer; AValue: integer);');
    RegisterMethod('function gettagvalint(AIndex: integer): integer;');

    RegisterMethod('procedure settagvallong(AIndex: integer; AValue: int64);');
    RegisterMethod('function gettagvallong(AIndex: integer): int64;');

    RegisterMethod('procedure settagvaldouble(AIndex: integer; AValue: double);');
    RegisterMethod('function gettagvaldouble(AIndex: integer): double;');

    RegisterMethod('procedure settagvalstring(AIndex: integer; AValue: string);');
    RegisterMethod('function gettagvalstring(AIndex: integer): string;');

    RegisterMethod('function istaggood(AIndex: integer): boolean;');
  end;
end;




procedure SIRegister_visscada_TypesAndConsts(cl: TPSPascalCompiler);
begin
{
  cl.AddTypeS('TEditCharCase', '(ecNormal, ecUpperCase, ecLowerCase)');
  cl.AddTypeS('TOwnerDrawState', 'set of TEOwnerDrawState');
}
end;


procedure SIRegister_visscada(cl: TPSPascalCompiler);
begin
  SIRegister_visscada_TypesAndConsts(cl);
  SIRegisterTCUSTOMSCADAOBJECT(Cl);
  SIRegisterTVISLABEL(Cl);
  SIRegisterTVISCHECKBOX(Cl);
  SIRegisterTVISCOMBOBOX(Cl);
  SIRegisterTVISTRACKBAR(Cl);
  SIRegisterTVISRADIOBUTTON(Cl);
  SIRegisterTVISNUMERICPANEL(Cl);
  SIRegisterTVISDATABOARD(Cl);
end;


end.





