{ STDCtrls import unit } 
unit uPSR_visscada;

{$I PascalScript.inc}       
interface
uses
  uPSRuntime, uPSUtils;


procedure RIRegisterTCUSTOMSCADAOBJECT(Cl: TPSRuntimeClassImporter);
procedure RIRegisterTVISLABEL(Cl: TPSRuntimeClassImporter);
procedure RIRegisterTVISCHECKBOX(Cl: TPSRuntimeClassImporter);
procedure RIRegisterTVISCOMBOBOX(Cl: TPSRuntimeClassImporter);
procedure RIRegisterTVISTRACKBAR(Cl: TPSRuntimeClassImporter);
procedure RIRegisterTVISRADIOBUTTON(Cl: TPSRuntimeClassImporter);
procedure RIRegisterTVISNUMERICPANEL(Cl: TPSRuntimeClassImporter);
procedure RIRegisterTVISDATABOARD(Cl: TPSRuntimeClassImporter);

procedure RIRegister_visscada(cl: TPSRuntimeClassImporter);

implementation
uses
  ScadaBase,
  VisLabel,
  VisCheckBox,
  VisComboBox,
  VisTrackBar,
  VisRadioButton,
  VisNumericPanel,
  VisDataboard
  ;



// TCustomScadaObject
procedure RIRegisterTCUSTOMSCADAOBJECT(Cl: TPSRuntimeClassImporter);
begin
  Cl.Add(TCUSTOMSCADAOBJECT);
end;

// TVisLabel
procedure RIRegisterTVISLABEL(Cl: TPSRuntimeClassImporter);
begin
  with Cl.Add(TVISLABEL) do
  begin
    RegisterMethod(@TVisLabel.GetTagVal, 'GETTAGVAL');
    RegisterMethod(@TVisLabel.SetTagVal, 'SETTAGVAL');

    RegisterMethod(@TVisLabel.GetTagValBool, 'GETTAGVALBOOL');
    RegisterMethod(@TVisLabel.SetTagValBool, 'SETTAGVALBOOL');

    RegisterMethod(@TVisLabel.GetTagValInt, 'GETTAGVALINT');
    RegisterMethod(@TVisLabel.SetTagValInt, 'SETTAGVALINT');

    RegisterMethod(@TVisLabel.GetTagValLong, 'GETTAGVALLONG');
    RegisterMethod(@TVisLabel.SetTagValLong, 'SETTAGVALLONG');

    RegisterMethod(@TVisLabel.GetTagValDouble, 'GETTAGVALDOUBLE');
    RegisterMethod(@TVisLabel.SetTagValDouble, 'SETTAGVALDOUBLE');

    RegisterMethod(@TVisLabel.GetTagValString, 'GETTAGVALSTRING');
    RegisterMethod(@TVisLabel.SetTagValString, 'SETTAGVALSTRING');

    RegisterMethod(@TVisLabel.IsTagGood, 'ISTAGGOOD');

    RegisterMethod(@TVisLabel.FloatCaption, 'FLOATCAPTION');
    RegisterMethod(@TVisLabel.SetColors, 'SETCOLORS');
  end;
end;

// TVisCheckBox
procedure RIRegisterTVISCHECKBOX(Cl: TPSRuntimeClassImporter);
begin
  with Cl.Add(TVISCHECKBOX) do
  begin
    RegisterMethod(@TVisCheckBox.IsApplying, 'ISAPPLYING');
    RegisterMethod(@TVisCheckBox.GetTagVal, 'GETTAGVAL');
    RegisterMethod(@TVisCheckBox.SetTagVal, 'SETTAGVAL');

    RegisterMethod(@TVisCheckBox.GetTagValBool, 'GETTAGVALBOOL');
    RegisterMethod(@TVisCheckBox.SetTagValBool, 'SETTAGVALBOOL');

    RegisterMethod(@TVisCheckBox.GetTagValInt, 'GETTAGVALINT');
    RegisterMethod(@TVisCheckBox.SetTagValInt, 'SETTAGVALINT');

    RegisterMethod(@TVisCheckBox.GetTagValLong, 'GETTAGVALLONG');
    RegisterMethod(@TVisCheckBox.SetTagValLong, 'SETTAGVALLONG');

    RegisterMethod(@TVisCheckBox.GetTagValDouble, 'GETTAGVALDOUBLE');
    RegisterMethod(@TVisCheckBox.SetTagValDouble, 'SETTAGVALDOUBLE');

    RegisterMethod(@TVisCheckBox.GetTagValString, 'GETTAGVALSTRING');
    RegisterMethod(@TVisCheckBox.SetTagValString, 'SETTAGVALSTRING');

    RegisterMethod(@TVisCheckBox.IsTagGood, 'ISTAGGOOD');

    RegisterMethod(@TVisCheckBox.SetColors, 'SETCOLORS');
  end;
end;


// TVisComboBox
procedure RIRegisterTVISCOMBOBOX(Cl: TPSRuntimeClassImporter);
begin
  with Cl.Add(TVISCOMBOBOX) do
  begin
    RegisterMethod(@TVisComboBox.IsApplying, 'ISAPPLYING');
    RegisterMethod(@TVisComboBox.GetTagVal, 'GETTAGVAL');
    RegisterMethod(@TVisComboBox.SetTagVal, 'SETTAGVAL');

    RegisterMethod(@TVisComboBox.GetTagValBool, 'GETTAGVALBOOL');
    RegisterMethod(@TVisComboBox.SetTagValBool, 'SETTAGVALBOOL');

    RegisterMethod(@TVisComboBox.GetTagValInt, 'GETTAGVALINT');
    RegisterMethod(@TVisComboBox.SetTagValInt, 'SETTAGVALINT');

    RegisterMethod(@TVisComboBox.GetTagValLong, 'GETTAGVALLONG');
    RegisterMethod(@TVisComboBox.SetTagValLong, 'SETTAGVALLONG');

    RegisterMethod(@TVisComboBox.GetTagValDouble, 'GETTAGVALDOUBLE');
    RegisterMethod(@TVisComboBox.SetTagValDouble, 'SETTAGVALDOUBLE');

    RegisterMethod(@TVisComboBox.GetTagValString, 'GETTAGVALSTRING');
    RegisterMethod(@TVisComboBox.SetTagValString, 'SETTAGVALSTRING');

    RegisterMethod(@TVisComboBox.IsTagGood, 'ISTAGGOOD');

    RegisterMethod(@TVisComboBox.SetColors, 'SETCOLORS');
  end;
end;

// TVisTrackBar
procedure RIRegisterTVISTRACKBAR(Cl: TPSRuntimeClassImporter);
begin
  with Cl.Add(TVISTRACKBAR) do
  begin
    RegisterMethod(@TVisTrackBar.IsApplying, 'ISAPPLYING');
    RegisterMethod(@TVisTrackBar.GetTagVal, 'GETTAGVAL');
    RegisterMethod(@TVisTrackBar.SetTagVal, 'SETTAGVAL');

    RegisterMethod(@TVisTrackBar.GetTagValBool, 'GETTAGVALBOOL');
    RegisterMethod(@TVisTrackBar.SetTagValBool, 'SETTAGVALBOOL');

    RegisterMethod(@TVisTrackBar.GetTagValInt, 'GETTAGVALINT');
    RegisterMethod(@TVisTrackBar.SetTagValInt, 'SETTAGVALINT');

    RegisterMethod(@TVisTrackBar.GetTagValLong, 'GETTAGVALLONG');
    RegisterMethod(@TVisTrackBar.SetTagValLong, 'SETTAGVALLONG');

    RegisterMethod(@TVisTrackBar.GetTagValDouble, 'GETTAGVALDOUBLE');
    RegisterMethod(@TVisTrackBar.SetTagValDouble, 'SETTAGVALDOUBLE');

    RegisterMethod(@TVisTrackBar.GetTagValString, 'GETTAGVALSTRING');
    RegisterMethod(@TVisTrackBar.SetTagValString, 'SETTAGVALSTRING');

    RegisterMethod(@TVisTrackBar.IsTagGood, 'ISTAGGOOD');

    RegisterMethod(@TVisTrackBar.SetColors, 'SETCOLORS');
  end;
end;

// TVisRadioButton
procedure RIRegisterTVISRADIOBUTTON(Cl: TPSRuntimeClassImporter);
begin
  with Cl.Add(TVISRADIOBUTTON) do
  begin
    RegisterMethod(@TVisRadioButton.IsApplying, 'ISAPPLYING');
    RegisterMethod(@TVisRadioButton.GetTagVal, 'GETTAGVAL');
    RegisterMethod(@TVisRadioButton.SetTagVal, 'SETTAGVAL');

    RegisterMethod(@TVisRadioButton.GetTagValBool, 'GETTAGVALBOOL');
    RegisterMethod(@TVisRadioButton.SetTagValBool, 'SETTAGVALBOOL');

    RegisterMethod(@TVisRadioButton.GetTagValInt, 'GETTAGVALINT');
    RegisterMethod(@TVisRadioButton.SetTagValInt, 'SETTAGVALINT');

    RegisterMethod(@TVisRadioButton.GetTagValLong, 'GETTAGVALLONG');
    RegisterMethod(@TVisRadioButton.SetTagValLong, 'SETTAGVALLONG');

    RegisterMethod(@TVisRadioButton.GetTagValDouble, 'GETTAGVALDOUBLE');
    RegisterMethod(@TVisRadioButton.SetTagValDouble, 'SETTAGVALDOUBLE');

    RegisterMethod(@TVisRadioButton.GetTagValString, 'GETTAGVALSTRING');
    RegisterMethod(@TVisRadioButton.SetTagValString, 'SETTAGVALSTRING');

    RegisterMethod(@TVisRadioButton.IsTagGood, 'ISTAGGOOD');

    RegisterMethod(@TVisRadioButton.SetColors, 'SETCOLORS');
  end;
end;

// TVisNumericPanel
procedure RIRegisterTVISNUMERICPANEL(Cl: TPSRuntimeClassImporter);
begin
  with Cl.Add(TVISNUMERICPANEL) do
  begin
    RegisterMethod(@TVisNumericPanel.IsApplying, 'ISAPPLYING');
    RegisterMethod(@TVisNumericPanel.GetTagVal, 'GETTAGVAL');
    RegisterMethod(@TVisNumericPanel.SetTagVal, 'SETTAGVAL');

    RegisterMethod(@TVisNumericPanel.GetTagValBool, 'GETTAGVALBOOL');
    RegisterMethod(@TVisNumericPanel.SetTagValBool, 'SETTAGVALBOOL');

    RegisterMethod(@TVisNumericPanel.GetTagValInt, 'GETTAGVALINT');
    RegisterMethod(@TVisNumericPanel.SetTagValInt, 'SETTAGVALINT');

    RegisterMethod(@TVisNumericPanel.GetTagValLong, 'GETTAGVALLONG');
    RegisterMethod(@TVisNumericPanel.SetTagValLong, 'SETTAGVALLONG');

    RegisterMethod(@TVisNumericPanel.GetTagValDouble, 'GETTAGVALDOUBLE');
    RegisterMethod(@TVisNumericPanel.SetTagValDouble, 'SETTAGVALDOUBLE');

    RegisterMethod(@TVisNumericPanel.GetTagValString, 'GETTAGVALSTRING');
    RegisterMethod(@TVisNumericPanel.SetTagValString, 'SETTAGVALSTRING');

    RegisterMethod(@TVisNumericPanel.IsTagGood, 'ISTAGGOOD');

    RegisterMethod(@TVisNumericPanel.SetColors, 'SETCOLORS');
  end;
end;


// TVisDataboard
procedure RIRegisterTVISDATABOARD(Cl: TPSRuntimeClassImporter);
begin
  with Cl.Add(TVISDATABOARD) do
  begin
    RegisterMethod(@TVisDataboard.GetTagVal, 'GETTAGVAL');
    RegisterMethod(@TVisDataboard.SetTagVal, 'SETTAGVAL');

    RegisterMethod(@TVisDataboard.GetTagValBool, 'GETTAGVALBOOL');
    RegisterMethod(@TVisDataboard.SetTagValBool, 'SETTAGVALBOOL');

    RegisterMethod(@TVisDataboard.GetTagValInt, 'GETTAGVALINT');
    RegisterMethod(@TVisDataboard.SetTagValInt, 'SETTAGVALINT');

    RegisterMethod(@TVisDataboard.GetTagValLong, 'GETTAGVALLONG');
    RegisterMethod(@TVisDataboard.SetTagValLong, 'SETTAGVALLONG');

    RegisterMethod(@TVisDataboard.GetTagValDouble, 'GETTAGVALDOUBLE');
    RegisterMethod(@TVisDataboard.SetTagValDouble, 'SETTAGVALDOUBLE');

    RegisterMethod(@TVisDataboard.GetTagValString, 'GETTAGVALSTRING');
    RegisterMethod(@TVisDataboard.SetTagValString, 'SETTAGVALSTRING');

    RegisterMethod(@TVisDataboard.IsTagGood, 'ISTAGGOOD');

    RegisterMethod(@TVisDataboard.FloatCaption, 'FLOATCAPTION');
    RegisterMethod(@TVisDataboard.SetColors, 'SETCOLORS');
  end;
end;

procedure RIRegister_visscada(cl: TPSRuntimeClassImporter);
begin
  RIRegisterTCUSTOMSCADAOBJECT(Cl);
  RIRegisterTVISLABEL(Cl);
  RIRegisterTVISCHECKBOX(Cl);
  RIRegisterTVISCOMBOBOX(Cl);
  RIRegisterTVISTRACKBAR(Cl);
  RIRegisterTVISRADIOBUTTON(Cl);
  RIRegisterTVISNUMERICPANEL(Cl);
  RIRegisterTVISDATABOARD(Cl);
end;


end.


