unit utils;

interface
uses
  ComCtrls,
  SysUtils;

  function toPaddingNumbersLeft(s: string): string;

  function binarySearchInt(var arr: array of integer; x: integer; nearest: boolean = false): integer;

  function IntToStrPair(a, b: integer; delimiter: char = '.'): string;
  procedure StrToIntPair(s: string; var a: Integer; var b: integer; delimiter: char = '.');


implementation
uses
  HyperStr;

function toPaddingNumbersLeft(s: string): string;
var
  i,j,k,v: integer;
  c: Char;
begin
  Result := '';
  k := 1;
  s := s + ' ';
  for i:=1 to Length(s) do begin
    c := s[i];
    if not( c in ['0'..'9'] ) then begin
      if k < i then begin
        Val(Copy(s, k, i - k), v, j);
        v := v + 1000000;
        Result := Result + IntToStr(v);
      end;
      Result := Result + c;
      k := i + 1;
    end;
  end;
end;


function binarySearchInt(var arr: array of integer; x: integer; nearest: boolean): integer;
var
  l, h, m: Integer;
begin
  m := 0;
  l := 0;
  h := length(arr) - 1;
  while l <= h do begin
    m := l + (h - l) div 2;

    if arr[m] = x then begin
      result := m;
      Exit;
    end;

    if arr[m] < x then
      l := m + 1
    else
      h := m - 1;
  end;

  if nearest then begin
    if (m < length(arr)) and (arr[m] < x) then
      inc(m);

    Result := m;
  end else begin
    Result := -1;
  end;

end;



function IntToStrPair(a, b: integer; delimiter: char = '.'): string;
begin
  Result := IntToStr(a) + delimiter + IntToStr(b);
end;


procedure StrToIntPair(s: string; var a: Integer; var b: integer; delimiter: char = '.');
var
  k: Integer;
begin
  a := 0;
  b := 0;
  k := Pos(delimiter, s);
  if k > 0 then begin
    a := StrToIntDef(Copy(s, 1, k-1), 0);
    b := StrToIntDef(IStr(s, k+1), 0);
  end;
end;


end.
