unit Gelios_prop;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ScadaBase, VisMachine, VisMcha, ExtCtrls, VisDltB,
  VisStatusShape, VisZDVH, VisZDVT, jpeg, SimpleLine, PolyLine, VisButton,
  Buttons, VisLabel, ComCtrls, VisControl;

type
  TGelios_propForm = class(TForm)
    BitBtn1: TBitBtn;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    Timer1: TTimer;
    Label13: TLabel;
    Label23: TLabel;
    VisLabel13: TVisLabel;
    VisLabel17: TVisLabel;                                
    Bevel1: TBevel;
    Label1: TLabel;
    Bevel2: TBevel;
    Label2: TLabel;
    vlStatus0: TVisLabel;
    Label3: TLabel;
    VisLabel2: TVisLabel;
    Label7: TLabel;
    VisLabel5: TVisLabel;
    Label8: TLabel;
    VisLabel6: TVisLabel;
    Label9: TLabel;
    VisLabel7: TVisLabel;
    vlStatus1: TVisLabel;
    lbl1: TLabel;
    VisLabel1: TVisLabel;
    procedure VisGetTagIndex(TagName: String; var TagIndex: Integer);
    procedure VisGetTagValue(TagIndex: Integer; var Value: Integer);
    procedure VisualDeviceClick(Sender: TObject);
    procedure TabSheetMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Timer1Timer(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure VisSetTagValue(TagIndex, Value: Integer);
    procedure VisLabelClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
  public
    TagPath: string;
    TagRoot: string;
    DeviceName: string;
  end;


  procedure _Gelios_Click(AOwner: TComponent; Sender: TObject; ver: integer=0);

implementation
uses
  numbers,
  TagStorage,
  connecting,
  meslogging,
  SetChannel,
  trendwindow,
  RpVisualGlobal,
  RpVisualLegacyPanels,
  RpVisualUtils,
  RpVisualMain;


var
  _TagPath: string;
  _TagRoot: string;

{$R *.dfm}

procedure TGelios_propForm.VisGetTagIndex(TagName: String;
  var TagIndex: Integer);
begin
  TagIndex := GetTagIndex(TagName);
end;

procedure TGelios_propForm.VisGetTagValue(TagIndex: Integer;
  var Value: Integer);
begin
  Value := GetTagValue(TagIndex);
end;

procedure TGelios_propForm.VisSetTagValue(TagIndex, Value: Integer);
begin
  SetTagValue(TagIndex, Value);
end;

procedure TGelios_propForm.VisualDeviceClick(Sender: TObject);
begin
  _VisualDeviceClick(sender);
end;

procedure TGelios_propForm.TabSheetMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  _TabSheetMouseDown(Sender, Button, Shift, X, Y);
end;


procedure _proc(Target: TCustomScadaObject);
begin
  if Target.ClassType = TVisLabel then
    with Target as TVisLabel do begin
      TagPath := _TagPath;
      TagRoot := _TagRoot;
    end;
  if Target.ClassType = TVisButton then
    with Target as TVisButton do begin
      TagPath := _TagPath;
//      TagRoot := _TagRoot;
    end;
end;

procedure TGelios_propForm.FormActivate(Sender: TObject);
begin
  _TagPath := TagPath;
  _TagRoot := TagRoot;
  Caption := DeviceName;
  CustomScanScadaObjects(self, _proc);
  CustomScanScadaObjects(self, InitDeviceProc);

  Timer1Timer(nil);
end;

procedure TGelios_propForm.Timer1Timer(Sender: TObject);
begin
  if not rvgLogIn then exit;
  CustomScanScadaObjects(self, UpdateDeviceProc);
end;

procedure TGelios_propForm.Button1Click(Sender: TObject);
var
  FChnlIn: integer;
  FTagChnlIn: integer;
begin
  FTagChnlIn := GetTagIndex(TagPath + '.MDTA_' + TagRoot + '_Channel');
  if FTagChnlIn=-1 then exit;

  FChnlIn := GetTagValue(FTagChnlIn);

  SetChannelForm.Channel := FChnlIn;
  if SetChannelForm.ShowModal = mrOk then begin
    SaveMessage(19, DeviceName,
        IntToStr(SetChannelForm.Channel shr 8) + '-' +
        IntToStr(SetChannelForm.Channel and $7F) +
        iif((SetChannelForm.Channel and $80)>0, 'f',''));

    SetTagValue( FTagChnlIn, $10000 + SetChannelForm.Channel );
  end;
end;

procedure TGelios_propForm.VisLabelClick(Sender: TObject);
var
  s: string;
  i,j: integer;
begin
  with sender as TVisLabel do begin
    s := inttostr(gettagval(0));
    if InputQuery(' ', ' ', s) then begin
      val(s, i, j);
      SetTagValue(gettagidx(0), i);
      SaveMessage(14, DeviceName, get_clear_hint(Hint) + ' = ' + inttostr(i));
    end;
  end;

end;


////////////////////////////////////////////////////////////////////////////////
// ver -   
//     = 0 -  (      )
//     = 1 -   (   )
////////////////////////////////////////////////////////////////////////////////
procedure _Gelios_Click(AOwner: TComponent; Sender: TObject; ver: integer=0);
var
  w: TGelios_propForm;
begin
  if not rvgLogIn then exit;

  w := TGelios_propForm.Create(AOwner);
  w.vlStatus0.Visible := ver=0;
  w.vlStatus1.Visible := ver=1;

  with sender as TVisLabel do try
    w.TagPath := TagPath;
    w.TagRoot := TagRoot;
    w.DeviceName := get_clear_hint(Hint);
    w.ShowModal;
  finally
    w.Free;
  end;
end;


procedure TGelios_propForm.FormCreate(Sender: TObject);
begin
  vlStatus1.Width := vlStatus0.Width;
end;

end.
