unit ScreenCmd;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ScadaBase, VisMachine, VisMcha, ExtCtrls, VisDltB,
  VisStatusShape, VisZDVH, VisZDVT, jpeg, SimpleLine, Buttons,
  ComCtrls, VisLabel, VisDataboard, frxpngimage, AdvGlowButton;

type
  TScreenCmdForm = class(TForm)
    pnlCmd: TPanel;
    Image1: TImage;
    btnSC: TAdvGlowButton;
    btnCmd1: TAdvGlowButton;
    btnWesClient: TAdvGlowButton;
    btnMain: TAdvGlowButton;
    Shape1: TShape;
    Label1: TLabel;
    procedure TabSheetMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Image1Click(Sender: TObject);
    procedure Image2Click(Sender: TObject);
    procedure Image3Click(Sender: TObject);
    procedure WesClientClick(Sender: TObject);
    procedure SpeedButton11Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ScreenCmdForm: TScreenCmdForm;

implementation
uses
  ScreenCmdSC,
  ScreenCmd00,
  ScreenCmd01,
  TagStorage,
  main,
  RpVisualGlobal,
  RpVisualLegacyPanels,
  RpVisualUtils,
  RpVisualMain;


{$R *.dfm}

////////////////////////////////////////////////////////////////////////////////
procedure TScreenCmdForm.TabSheetMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  _TabSheetMouseDown(Sender, Button, Shift, X, Y);
end;
////////////////////////////////////////////////////////////////////////////////

procedure TScreenCmdForm.ButtonClick(Sender: TObject);

  procedure _make(cls: TFormClass; var frm: TForm);
  begin
    if _AddFormToWinControl(pnlCmd, cls, frm ) then
      CustomScanScadaObjects(frm, InitDeviceProc);

    if Assigned(frm.OnActivate) then frm.OnActivate(nil);
  end;

begin
  if sender = btnMain then _make(TScreenCmd00Form, TForm(ScreenCmd00Form));
  if sender = btnCmd1 then _make(TScreenCmd01Form, TForm(ScreenCmd01Form));
  if sender = btnSC then _make(TScreenCmdSCForm, TForm(ScreenCmdSCForm));
end;

procedure TScreenCmdForm.FormCreate(Sender: TObject);
begin
  ButtonClick(btnCmd1);
  Align := alClient;
end;

procedure TScreenCmdForm.Image1Click(Sender: TObject);
begin
  Form1.PageControl.ActivePageIndex := 1;
end;

procedure TScreenCmdForm.Image2Click(Sender: TObject);
begin
  Form1.PageControl.ActivePageIndex := 2;
end;

procedure TScreenCmdForm.Image3Click(Sender: TObject);
begin
  Form1.PageControl.ActivePageIndex := 3;
end;

procedure TScreenCmdForm.WesClientClick(Sender: TObject);
begin
  StartProgram(
    ' ',
    'wesclient',                                         
    'D:\ASUTP\WORK_SHD\WesClient\WesClient.exe'
  );

end;

procedure TScreenCmdForm.SpeedButton11Click(Sender: TObject);
begin
  StartProgram(
    '',
    'trmsvr',
    ''
  );

end;

end.
