unit ScreenCmd01;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ScadaBase, VisMachine, VisMcha, ExtCtrls, Buttons,
  VisLabel, VisCheckBox, VisRadioButton, VisButton, VisDataboard,
  VisComboBox, Menus, VisControl;


type
  TScreenCmd01Form = class(TForm)
    PnlS01: TPanel;
    PnlS02: TPanel;
    PnlS03a: TPanel;
    PnlS04: TPanel;
    PnlS05: TPanel;
    PnlS06: TPanel;
    PnlS07: TPanel;
    lbName: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    VisDataboard10: TVisDataboard;
    VisButton25: TVisButton;
    VisButton26: TVisButton;
    VisButton27: TVisButton;
    VisButton28: TVisButton;
    VisDataboard11: TVisDataboard;
    PnlS03: TPanel;
    btFullRestart: TButton;
    procedure TabSheetMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure VisualDeviceClick(Sender: TObject);
    procedure btStartClick(Sender: TObject);
    procedure btStopClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure StartStopClick(Sender: TObject);
    procedure btFullRestartClick(Sender: TObject);
    { Private declarations }
  public
    { Public declarations }
  end;                                                            

var
  ScreenCmd01Form: TScreenCmd01Form;

implementation
uses
  PerlRegEx,
  SQBA_Params,
  VisSeqdControl,
  Connecting,
  meslogging,
  TagStorage,
  numbers,
  RpVisualGlobal,
  RpVisualLegacyPanels,
  RpVisualUtils,
  RpVisualMain;


{$R *.dfm}

////////////////////////////////////////////////////////////////////////////////

procedure TScreenCmd01Form.VisualDeviceClick(Sender: TObject);
begin
  _VisualDeviceClick(sender);
end;

procedure TScreenCmd01Form.TabSheetMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  _TabSheetMouseDown(Sender, Button, Shift, X, Y);
end;
////////////////////////////////////////////////////////////////////////////////


procedure TScreenCmd01Form.btStartClick(Sender: TObject);
begin
  with sender as TVisButton do SaveMessage(15, Hint, CaptionDown );
//  if (Sender as TVisButton).Name='btStart' then
//  SetTagValueByName('WZRN.SetCmd',1);
end;

procedure TScreenCmd01Form.btStopClick(Sender: TObject);
begin
  with sender as TVisButton do SaveMessage(16, Hint, CaptionDown );
end;

procedure TScreenCmd01Form.FormCreate(Sender: TObject);
var
  i: Integer;
begin

  with createVisSeqdControl(PnlS01, '', 'S01', ' 1:  ') do begin
    btSusp.Visible := false;
//    dbrd.
  end;

  with createVisSeqdControl(PnlS02, '', 'S02', ' 2: ') do
    btSusp.Visible := false;

  with createVisSeqdControl(PnlS03, '', 'S03', ' 3:   ') do
    btSusp.Visible := false;

  with createVisSeqdControl(PnlS04, '', 'S04', ' 4:  2') do
    btSusp.Visible := false;

  with createVisSeqdControl(PnlS05, '', 'S05', ' 5: ') do
    btSusp.Visible := false;

  with createVisSeqdControl(PnlS06, '', 'S06', ' 6:  3 ( )') do
    btSusp.Visible := false;

//  with createVisSeqdControl(PnlS07, '', 'S07', ' 7: ') do
//    btSusp.Visible := false;


//  for i:=0 to ComponentCount-1 do
//    if Components[i] is TPanel then
//      with Components[i] as TPanel do
//        if Components[0] is TSeqdControlForm then
//          with Components[0] as TSeqdControlForm do begin
//            lbName.Font.Color := clWhite;
//          end;


end;

procedure TScreenCmd01Form.StartStopClick(Sender: TObject);
begin
  with Sender as TVisButton do
    _SaveMessageScadaObject(Sender, CaptionDown + ' ', $000080FF);
end;

procedure TScreenCmd01Form.btFullRestartClick(Sender: TObject);
var
  regex: TPerlRegEx;
  n, i: integer;
  tagname: string;
  value: integer;
begin
  //
  if MessageDlg('!!!'#13'   ?', mtWarning, mbOKCancel, 0) <> mrOk then exit; 

//  showmessage('1');

  regex := TPerlRegEx.Create;

  n := DataClient.getTagCount;
  regex.RegEx := '.*\.MCHB_.*_Control';

//  showmessage('n = ' + inttostr(n));

  for i:=0 to n-1 do begin
    tagname := DataClient.getTagName(i);
    value := DataClient.getValInt(i);

    regex.Subject := tagname;
    if regex.Match then begin
//      if (value and 3) = 3 then
//        continue;

      DataClient.setValInt(i, value or 4);
//      showmessage('4 - ' + tagname + ' = ' + inttostr(value or 4));
    end;
  end;

  regex.Free;

//  showmessage('4');

  try
    SaveMessageText('  ', '', '', clYellow);
  except
    ShowMessage('wtf?');
  end;
//  showmessage('5');

end;

end.
