unit ScreenCmdSC;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ScadaBase, VisMachine, VisMcha, ExtCtrls, Buttons,
  VisLabel, VisCheckBox, VisRadioButton, VisButton, VisDataboard,
  VisComboBox, VisSeqc;

{ TODO :     }
type
  TScreenCmdSCForm = class(TForm)
    Bevel2: TBevel;
    btStart1: TVisButton;
    btStop1: TVisButton;
    VisSeqc1: TVisSeqc;
    Bevel1: TBevel;
    btStart2: TVisButton;
    btStop2: TVisButton;
    VisSeqc2: TVisSeqc;
    Bevel3: TBevel;
    btStart3: TVisButton;
    btStop3: TVisButton;
    VisSeqc3: TVisSeqc;
    Bevel4: TBevel;
    btStart4: TVisButton;
    btStop4: TVisButton;
    VisSeqc4: TVisSeqc;
    Bevel5: TBevel;
    btStart5: TVisButton;
    btStop5: TVisButton;
    VisSeqc5: TVisSeqc;
    procedure TabSheetMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure VisualDeviceClick(Sender: TObject);
    procedure btStart1Click(Sender: TObject);
    procedure btStop1Click(Sender: TObject);
  private
    function _get_seqc_name(Sender: TObject): string;
    function _get_seqc_hint(Sender: TObject): string;
    { Private declarations }
  public
    { Public declarations }
  end;                                                            

var
  ScreenCmdSCForm: TScreenCmdSCForm;

implementation
uses                  
  Connecting,
  meslogging,
  TagStorage,
  numbers,
  RpVisualGlobal,
  RpVisualLegacyPanels,
  RpVisualUtils,
  RpVisualMain;


{$R *.dfm}

////////////////////////////////////////////////////////////////////////////////

procedure TScreenCmdSCForm.VisualDeviceClick(Sender: TObject);
begin
  _VisualDeviceClick(sender);
end;

procedure TScreenCmdSCForm.TabSheetMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  _TabSheetMouseDown(Sender, Button, Shift, X, Y);
end;
////////////////////////////////////////////////////////////////////////////////

function TScreenCmdSCForm._get_seqc_name(Sender: TObject): string;
begin
  result := '';
  if sender=btStart1 then result := VisSeqc1.objLabel.Caption else
  if sender=btStart2 then result := VisSeqc2.objLabel.Caption else
  if sender=btStart3 then result := VisSeqc3.objLabel.Caption else
  if sender=btStart4 then result := VisSeqc4.objLabel.Caption else
  if sender=btStart5 then result := VisSeqc5.objLabel.Caption;
end;

function TScreenCmdSCForm._get_seqc_hint(Sender: TObject): string;
begin
  result := '';
  if sender=btStart1 then result := VisSeqc1.objLabel.hint else
  if sender=btStart2 then result := VisSeqc2.objLabel.hint else
  if sender=btStart3 then result := VisSeqc3.objLabel.hint else
  if sender=btStart4 then result := VisSeqc4.objLabel.hint else
  if sender=btStart5 then result := VisSeqc5.objLabel.hint;
end;

procedure TScreenCmdSCForm.btStart1Click(Sender: TObject);
begin
  with sender as TVisButton do SaveMessage(15, _get_seqc_name(sender), _get_seqc_hint(sender) );
end;

procedure TScreenCmdSCForm.btStop1Click(Sender: TObject);
begin
  with sender as TVisButton do SaveMessage(16, _get_seqc_name(sender), '' );
end;


end.
